document.addEventListener('DOMContentLoaded', () => {
    // Common JS for Bar Management System
    console.log('App initialized');
    // Printer mode selector
    const sel = document.getElementById('printerMode');
    if (sel) {
        const stored = localStorage.getItem('printerMode') || 'normal';
        sel.value = stored;
        applyPrinterMode(stored);
        sel.addEventListener('change', (e) => {
            const val = e.target.value;
            localStorage.setItem('printerMode', val);
            applyPrinterMode(val);
        });
    }
});

function applyPrinterMode(mode) {
    // Apply to invoice container if present
    const inv = document.querySelector('.invoice');
    if (inv) {
        inv.classList.toggle('thermal', mode === 'thermal');
        inv.classList.toggle('normal', mode === 'normal');
    }
}
