<?php
// A4 Invoice Template
// Variables expected: $companyInfo, $sale, $items (array), $printerSettings (assoc), $qrUrl (if QR enabled)
?>
<!DOCTYPE html>
<html>
<head>
  <meta charset="UTF-8">
  <title>Invoice #<?= $sale['id'] ?></title>
  <style>
    .invoice-a4 { width:210mm; margin:auto; font-family:Arial,sans-serif; font-size:14px; }
    .invoice-a4 .header { text-align:center; margin-bottom:20px; }
    .invoice-a4 table { width:100%; border-collapse:collapse; margin-bottom:20px; }
    .invoice-a4 th, .invoice-a4 td { border:1px solid #333; padding:8px; }
    .invoice-a4 tfoot th { text-align:right; }
  </style>
</head>
<body>
<div class="invoice-a4">
  <div class="header">
    <h1><?= htmlspecialchars($companyInfo['company_name'] ?? '') ?></h1>
    <p><?= nl2br(htmlspecialchars($companyInfo['address'] ?? '')) ?></p>
    <?php if (!empty($printerSettings['qr_code_enable']) && !empty($qrUrl)): ?>
      <img src="<?= $qrUrl ?>" alt="QR Code" style="margin-top:10px;" />
    <?php endif; ?>
  </div>
  <h2>Invoice #<?= $sale['id'] ?></h2>
  <p><strong>Date:</strong> <?= $sale['sale_date'] ?></p>
  <p><strong>Cashier:</strong> <?= htmlspecialchars($sale['full_name']) ?></p>
  <table>
    <thead>
      <tr><th>Product</th><th>Qty</th><th>Price</th><th>Total</th></tr>
    </thead>
    <tbody>
    <?php foreach ($items as $it): ?>
      <tr>
        <td><?= htmlspecialchars($it['name']) ?></td>
        <td><?= intval($it['quantity']) ?></td>
        <td>₹<?= number_format($it['price'],2) ?></td>
        <td>₹<?= number_format($it['total'],2) ?></td>
      </tr>
    <?php endforeach; ?>
    </tbody>
    <tfoot>
      <tr>
        <th colspan="3">Grand Total</th>
        <th>₹<?= number_format($sale['total_amount'],2) ?></th>
      </tr>
    </tfoot>
  </table>
  <div class="footer">
    <p><?= nl2br(htmlspecialchars($printerSettings['footer_text'] ?? '')) ?></p>
  </div>
</div>
</body>
</html>
