<?php
require_once __DIR__ . '/includes/config.php';
require_once __DIR__ . '/includes/core.php';
require_once __DIR__ . '/includes/db.php';

// Redirect if already logged in
auth_redirect:
if (isLoggedIn()) redirect(BASE_URL . '/panels/admin/dashboard.php');

$error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = trim($_POST['username'] ?? '');
    $password = $_POST['password'] ?? '';
    if ($username && $password) {
        $stmt = mysqli_prepare($conn, "SELECT id,password,role FROM users WHERE username = ?");
        mysqli_stmt_bind_param($stmt, "s", $username);
        mysqli_stmt_execute($stmt);
        mysqli_stmt_store_result($stmt);
        if (mysqli_stmt_num_rows($stmt) === 1) {
            mysqli_stmt_bind_result($stmt, $id, $hash, $role);
            mysqli_stmt_fetch($stmt);
            if (password_verify($password, $hash)) {
                $_SESSION['user_id']   = $id;
                $_SESSION['role']      = $role;
                $_SESSION['username']  = $username;
                mysqli_stmt_close($stmt);
                redirect(BASE_URL . "/panels/{$role}/dashboard.php");
            } else {
                $error = 'Invalid username or password.';
            }
        } else {
            $error = 'Invalid username or password.';
        }
        mysqli_stmt_close($stmt);
    } else {
        $error = 'Please enter credentials.';
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>Login - Bar Management</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="d-flex align-items-center justify-content-center" style="height:100vh;background:#f8f9fa;">
  <div class="card p-4" style="width:320px;">
    <h4 class="mb-3">Login</h4>
    <?php if (
        $error
    ): ?>
      <div class="alert alert-danger"><?= htmlspecialchars(
        $error
    ) ?></div>
    <?php endif; ?>
    <form method="POST">
      <div class="mb-3">
        <label class="form-label">Username</label>
        <input type="text" name="username" class="form-control" required>
      </div>
      <div class="mb-3">
        <label class="form-label">Password</label>
        <input type="password" name="password" class="form-control" required>
      </div>
      <button class="btn btn-primary w-100">Login</button>
    </form>
  </div>
</body>
</html>
