<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../includes/core.php';
if (!isLoggedIn() || getRole() !== 'admin') redirect(BASE_URL . '/login.php');

// Handle activation toggle
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id = intval($_POST['id'] ?? 0);
    $newStatus = intval($_POST['status'] ?? 0);
    $stmt = mysqli_prepare($conn, "UPDATE counters SET is_active = ? WHERE id = ?");
    mysqli_stmt_bind_param($stmt, 'ii', $newStatus, $id);
    mysqli_stmt_execute($stmt);
    mysqli_stmt_close($stmt);
    redirect(BASE_URL . '/panels/admin/counter_activation.php');
}

// Fetch counters
$res = mysqli_query($conn, "SELECT id, name, is_active FROM counters ORDER BY name");
$counters = mysqli_fetch_all($res, MYSQLI_ASSOC);

ob_start();
?>
<h1>Counter Activation</h1>
<table class="table table-bordered table-striped">
  <thead>
    <tr><th>ID</th><th>Name</th><th>Status</th><th>Action</th></tr>
  </thead>
  <tbody>
    <?php foreach ($counters as $c): ?>
    <tr>
      <td><?= $c['id'] ?></td>
      <td><?= htmlspecialchars($c['name']) ?></td>
      <td><?= $c['is_active'] ? 'Active' : 'Inactive' ?></td>
      <td>
        <form method="post" style="display:inline;">
          <input type="hidden" name="id" value="<?= $c['id'] ?>">
          <input type="hidden" name="status" value="<?= $c['is_active'] ? 0 : 1 ?>">
          <button class="btn btn-sm <?= $c['is_active'] ? 'btn-danger' : 'btn-success' ?>">
            <?= $c['is_active'] ? 'Deactivate' : 'Activate' ?>
          </button>
        </form>
      </td>
    </tr>
    <?php endforeach; ?>
  </tbody>
</table>
<?php
$content = ob_get_clean();
require_once __DIR__ . '/../../includes/layout.php';
?>
