<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../includes/core.php';
if (!isLoggedIn() || getRole() !== 'admin') redirect(BASE_URL . '/login.php');
// Ensure sales tables
$createSales = "CREATE TABLE IF NOT EXISTS `sales` (
  `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `counter_id` INT UNSIGNED DEFAULT NULL,
  `sale_date` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `total_amount` DECIMAL(10,2) NOT NULL,
  `created_by` INT UNSIGNED DEFAULT NULL,
  `created_at` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_sales_counter` (`counter_id`),
  CONSTRAINT `fk_sales_counter` FOREIGN KEY (`counter_id`) REFERENCES `counters`(`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;";
mysqli_query($conn, $createSales) or die('Error ensuring sales table: '.mysqli_error($conn));
$createItems = "CREATE TABLE IF NOT EXISTS `sales_items` (
  `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `sale_id` INT UNSIGNED NOT NULL,
  `product_id` INT UNSIGNED NOT NULL,
  `quantity` INT NOT NULL,
  `price` DECIMAL(10,2) NOT NULL,
  `tax` DECIMAL(5,2) NOT NULL DEFAULT 0,
  `total` DECIMAL(10,2) NOT NULL,
  `created_at` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_si_sale` (`sale_id`),
  CONSTRAINT `fk_si_sale` FOREIGN KEY (`sale_id`) REFERENCES `sales`(`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;";
mysqli_query($conn, $createItems) or die('Error ensuring sales_items table: '.mysqli_error($conn));
// Fetch counters
$counters = mysqli_fetch_all(mysqli_query($conn, "SELECT id,name FROM counters ORDER BY name"), MYSQLI_ASSOC);
$counter_id = intval($_GET['counter_id'] ?? 0);
ob_start();
?>
<h1>Counter Sales</h1>
<form method="get" class="mb-3">
  <label>Select Counter:</label>
  <select name="counter_id" class="form-select w-auto d-inline">
    <option value="">All Counters</option>
    <?php foreach ($counters as $c): ?>
      <option value="<?= $c['id'] ?>" <?= $counter_id== $c['id']?'selected':'' ?>><?= htmlspecialchars($c['name']) ?></option>
    <?php endforeach ?>
  </select>
  <button class="btn btn-primary">Filter</button>
</form>
<?php if ($counter_id):
    // product summary for specific counter
    $sql = "SELECT p.name AS product, SUM(si.quantity) AS qty, SUM(si.total) AS total
            FROM sales_items si
            JOIN sales s ON si.sale_id = s.id
            JOIN products p ON si.product_id = p.id
            WHERE s.counter_id = $counter_id
            GROUP BY si.product_id";
    $rows = mysqli_fetch_all(mysqli_query($conn, $sql), MYSQLI_ASSOC);
?>
<h2>Sales for Counter: <?= htmlspecialchars(array_column($counters, 'name', 'id')[$counter_id] ?? '') ?></h2>
<table class="table table-bordered">
  <thead><tr><th>Product</th><th>Quantity</th><th>Total Amount</th></tr></thead>
  <tbody>
    <?php foreach ($rows as $r): ?>
    <tr>
      <td><?= htmlspecialchars($r['product']) ?></td>
      <td><?= $r['qty'] ?></td>
      <td><?= number_format($r['total'],2) ?></td>
    </tr>
    <?php endforeach; ?>
  </tbody>
</table>
<?php else:
    // summary per counter
    $sql = "SELECT c.id, c.name AS counter, SUM(si.quantity) AS qty, SUM(si.total) AS total
            FROM sales_items si
            JOIN sales s ON si.sale_id = s.id
            JOIN counters c ON s.counter_id = c.id
            GROUP BY c.id";
    $rows = mysqli_fetch_all(mysqli_query($conn, $sql), MYSQLI_ASSOC);
?>
<table class="table table-bordered">
  <thead><tr><th>Counter</th><th>Quantity</th><th>Total Amount</th><th>Actions</th></tr></thead>
  <tbody>
    <?php foreach ($rows as $r): ?>
    <tr>
      <td><?= htmlspecialchars($r['counter']) ?></td>
      <td><?= $r['qty'] ?></td>
      <td><?= number_format($r['total'],2) ?></td>
      <td><a href="?counter_id=<?= $r['id'] ?>" class="btn btn-sm btn-primary">View</a></td>
    </tr>
    <?php endforeach; ?>
  </tbody>
</table>
<?php endif; ?>
<?php
$content = ob_get_clean();
require_once __DIR__ . '/../../includes/layout.php';
?>
