<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../includes/core.php';
if (!isLoggedIn() || getRole() !== 'admin') redirect(BASE_URL . '/login.php');

$id = intval($_GET['id'] ?? 0);
$name = '';
$description = '';
$error = '';
if ($id) {
    $stmt = mysqli_prepare($conn, "SELECT name, description FROM floors WHERE id = ?");
    mysqli_stmt_bind_param($stmt, 'i', $id);
    mysqli_stmt_execute($stmt);
    mysqli_stmt_bind_result($stmt, $name, $description);
    mysqli_stmt_fetch($stmt);
    mysqli_stmt_close($stmt);
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = trim($_POST['name']);
    $description = trim($_POST['description']);
    if ($name) {
        if ($id) {
            $stmt = mysqli_prepare($conn, "UPDATE floors SET name = ?, description = ? WHERE id = ?");
            mysqli_stmt_bind_param($stmt, 'ssi', $name, $description, $id);
        } else {
            $stmt = mysqli_prepare($conn, "INSERT INTO floors (name, description) VALUES (?, ?)");
            mysqli_stmt_bind_param($stmt, 'ss', $name, $description);
        }
        mysqli_stmt_execute($stmt);
        mysqli_stmt_close($stmt);
        redirect(BASE_URL . '/panels/admin/floors.php');
    } else {
        $error = 'Floor name cannot be empty.';
    }
}

ob_start();
?>
<h1><?= $id ? 'Edit' : 'Add' ?> Floor</h1>
<?php if ($error): ?>
  <div class="alert alert-danger"><?= htmlspecialchars($error) ?></div>
<?php endif; ?>
<form method="POST">
  <div class="mb-3">
    <label class="form-label">Floor Name</label>
    <input type="text" name="name" class="form-control" value="<?= htmlspecialchars($name) ?>" required>
  </div>
  <div class="mb-3">
    <label class="form-label">Description</label>
    <textarea name="description" class="form-control"><?= htmlspecialchars($description) ?></textarea>
  </div>
  <button class="btn btn-success"><?= $id ? 'Update' : 'Create' ?></button>
  <a href="<?= BASE_URL ?>/panels/admin/floors.php" class="btn btn-secondary">Cancel</a>
</form>
<?php
$content = ob_get_clean();
require_once __DIR__ . '/../../includes/layout.php';
?>
