<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../includes/core.php';
require_once __DIR__ . '/../../vendor/autoload.php';
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Cell\Coordinate;

if (!isLoggedIn() || getRole() !== 'admin') redirect(BASE_URL . '/login.php');

// Filters
date_default_timezone_set('Asia/Kolkata');
$from_date = $_GET['from_date'] ?? date('Y-m-01');
$to_date   = $_GET['to_date']   ?? date('Y-m-d');
$counter_id= isset($_GET['counter_id']) ? intval($_GET['counter_id']) : 0;

// Licence list
$cRes = mysqli_query($conn, "SELECT id,name FROM counters ORDER BY name") or die(mysqli_error($conn));
$counters = mysqli_fetch_all($cRes, MYSQLI_ASSOC);

// Sizes
$szRes = mysqli_query($conn, "SELECT id,name FROM sizes ORDER BY id") or die(mysqli_error($conn));
$sizes = mysqli_fetch_all($szRes, MYSQLI_ASSOC);

// Products
$pRes = mysqli_query($conn, "SELECT id,name,size_id FROM products ORDER BY name") or die(mysqli_error($conn));
$products = mysqli_fetch_all($pRes, MYSQLI_ASSOC);

// Compute opening
$cond = $counter_id ? "AND counter_id=$counter_id" : "";
$sql = "SELECT product_id, SUM(CASE WHEN movement_type='in' THEN quantity WHEN movement_type='out' THEN -quantity ELSE 0 END) AS qty
        FROM stock_movements
        WHERE created_at < '$from_date' $cond
        GROUP BY product_id";
$oRes = mysqli_query($conn, $sql) or die(mysqli_error($conn));
$opening = [];
while ($r = mysqli_fetch_assoc($oRes)) $opening[$r['product_id']] = (int)$r['qty'];

// Compute received
$sql = "SELECT product_id, SUM(quantity) AS qty
        FROM stock_movements
        WHERE movement_type='in' AND created_at BETWEEN '$from_date' AND '$to_date' $cond
        GROUP BY product_id";
$rRes = mysqli_query($conn, $sql) or die(mysqli_error($conn));
$received = [];
while ($r = mysqli_fetch_assoc($rRes)) $received[$r['product_id']] = (int)$r['qty'];

// Compute sold
$sc = $counter_id ? "AND s.counter_id=$counter_id" : "";
$sql = "SELECT si.product_id, SUM(si.quantity) AS qty
        FROM sales_items si
        JOIN sales s ON si.sale_id=s.id
        WHERE s.sale_date BETWEEN '$from_date' AND '$to_date' $sc
        GROUP BY si.product_id";
$sRes = mysqli_query($conn, $sql) or die(mysqli_error($conn));
$sold = [];
while ($r = mysqli_fetch_assoc($sRes)) $sold[$r['product_id']] = (int)$r['qty'];

// Brand/Size metrics for report
$targetSizes = $sizes;
$bRes = mysqli_query($conn, "SELECT id,name FROM brands ORDER BY name") or die(mysqli_error($conn));
$brands = mysqli_fetch_all($bRes, MYSQLI_ASSOC);
$openingB = $receivedB = $soldB = [];
foreach ($brands as $b) {
    foreach ($targetSizes as $sz) {
        $openingB[$b['id']][$sz['id']] = 0;
        $receivedB[$b['id']][$sz['id']] = 0;
        $soldB[$b['id']][$sz['id']]    = 0;
    }
}
// Filters for opening_stock and stock_movements
$openingCond = $counter_id ? "AND os.counter_id=$counter_id" : "";
$receivedCond = $counter_id ? "AND sm.counter_id=$counter_id" : "";
// Opening from opening_stock
$sql = "SELECT p.brand_id,p.size_id,SUM(os.quantity) AS qty
        FROM opening_stock os
        JOIN products p ON os.product_id=p.id
        WHERE os.created_at < DATE_ADD('$from_date', INTERVAL 1 DAY) $openingCond
        GROUP BY p.brand_id,p.size_id";
$oR = mysqli_query($conn, $sql) or die(mysqli_error($conn));
while ($r = mysqli_fetch_assoc($oR)) {
    $openingB[$r['brand_id']][$r['size_id']] = (int)$r['qty'];
}
// Received stock movements
$sql = "SELECT p.brand_id,p.size_id,SUM(sm.quantity) AS qty
        FROM stock_movements sm
        JOIN products p ON sm.product_id=p.id
        WHERE sm.movement_type='in'
          AND sm.created_at >= '$from_date'
          AND sm.created_at < DATE_ADD('$to_date', INTERVAL 1 DAY) $receivedCond
        GROUP BY p.brand_id,p.size_id";
$rR = mysqli_query($conn, $sql) or die(mysqli_error($conn));
while ($r = mysqli_fetch_assoc($rR)) {
    $receivedB[$r['brand_id']][$r['size_id']] = (int)$r['qty'];
}
// Sold
$sql = "SELECT p.brand_id,p.size_id,SUM(si.quantity) AS qty
        FROM sales_items si
        JOIN sales s ON si.sale_id=s.id
        JOIN products p ON si.product_id=p.id
        WHERE s.sale_date >= '$from_date'
          AND s.sale_date < DATE_ADD('$to_date', INTERVAL 1 DAY) $sc
        GROUP BY p.brand_id,p.size_id";
$sR = mysqli_query($conn, $sql) or die(mysqli_error($conn));
while ($r = mysqli_fetch_assoc($sR)) {
    $soldB[$r['brand_id']][$r['size_id']] = (int)$r['qty'];
}
// Closing stock as of now (from counter_stock)
$closingB = [];
foreach ($brands as $b) {
    foreach ($targetSizes as $sz) {
        $closingB[$b['id']][$sz['id']] = 0;
    }
}
$closingCond = $counter_id ? "AND cs.counter_id=$counter_id" : "";
$sql = "SELECT p.brand_id,p.size_id,SUM(cs.quantity) AS qty
        FROM counter_stock cs
        JOIN products p ON cs.product_id=p.id
        WHERE 1=1 $closingCond
        GROUP BY p.brand_id,p.size_id";
$cR = mysqli_query($conn, $sql) or die(mysqli_error($conn));
while ($r = mysqli_fetch_assoc($cR)) {
    $closingB[$r['brand_id']][$r['size_id']] = (int)$r['qty'];
}

// Export to Excel if requested
if (isset($_GET['export'])) {
    // Load FLR template, fill values, and stream as Excel
    $template = __DIR__ . '/../../FLRDetailsI.xlsx';
    $reader = \PhpOffice\PhpSpreadsheet\IOFactory::createReader('Xlsx');
    $spreadsheet = $reader->load($template);
    // Remove blank 'Sheet1' and activate the FLR template sheet
    if ($sheet1 = $spreadsheet->getSheetByName('Sheet1')) {
        $spreadsheet->removeSheetByIndex($spreadsheet->getIndex($sheet1));
    }
    if ($flrSheet = $spreadsheet->getSheetByName('FLRDetailsI')) {
        $spreadsheet->setActiveSheetIndex($spreadsheet->getIndex($flrSheet));
    }
    $sheet = $spreadsheet->getActiveSheet();
    // Data starts at row 8 to preserve template headers
    $startRow = 8;
    $row = $startRow;
    foreach ($brands as $b) {
        $sheet->setCellValue('A' . $row, $b['name']);
        $col = 2;
        foreach ($targetSizes as $sz) {
            $bid = $b['id']; $sid = $sz['id'];
            $sheet->setCellValueByColumnAndRow($col, $row, $openingB[$bid][$sid]);
            $sheet->setCellValueByColumnAndRow($col + 1, $row, $receivedB[$bid][$sid]);
            $sheet->setCellValueByColumnAndRow($col + 3, $row, $soldB[$bid][$sid]);
            // Closing balance
            $sheet->setCellValueByColumnAndRow($col + 4, $row, $closingB[$bid][$sid]);
            $col += 5;
        }
        $row++;
    }
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header('Content-Disposition: attachment;filename="FLRDetailsI.xlsx"');
    header('Cache-Control: max-age=0');
    $writer = new Xlsx($spreadsheet);
    $writer->setPreCalculateFormulas(true);
    $writer->save('php://output');
    exit;
}

// Display filter form and FLR report table
ob_start();
?>
<h1>FLR Report</h1>
<form method="get" class="form-inline mb-3">
  <label>From:&nbsp;<input type="date" name="from_date" value="<?=htmlspecialchars($from_date)?>" class="form-control"></label>&nbsp;
  <label>To:&nbsp;<input type="date" name="to_date" value="<?=htmlspecialchars($to_date)?>" class="form-control"></label>&nbsp;
  <label>Licence:&nbsp;<select name="counter_id" class="form-control">
    <option value="0">All</option>
    <?php foreach($counters as $c): ?>
      <option value="<?=$c['id']?>"<?=($c['id']==$counter_id?' selected':'')?>><?=htmlspecialchars($c['name'])?></option>
    <?php endforeach; ?>
  </select></label>&nbsp;
  <button class="btn btn-primary">Filter</button>
  <button class="btn btn-secondary" name="export" value="1">Download Excel</button>
</form>
<?php
// Build HTML view from FLRDetailsI template to match exact headers
$readerHtml = \PhpOffice\PhpSpreadsheet\IOFactory::createReader('Xlsx');
$ssHtml = $readerHtml->load(__DIR__ . '/../../FLRDetailsI.xlsx');
// Remove blank default sheet and activate FLRDetailsI sheet
if ($sheet1 = $ssHtml->getSheetByName('Sheet1')) {
    $ssHtml->removeSheetByIndex($ssHtml->getIndex($sheet1));
}
if ($flrSheet = $ssHtml->getSheetByName('FLRDetailsI')) {
    $ssHtml->setActiveSheetIndex($ssHtml->getIndex($flrSheet));
}
$shHtml = $ssHtml->getActiveSheet();
// Data at row 8 to keep headers intact
$startRowHtml = 8;
$rowHtml = $startRowHtml;
foreach ($brands as $b) {
    $shHtml->setCellValue('A'.$rowHtml, $b['name']);
    $colHtml = 2;
    foreach ($targetSizes as $sz) {
        $bid=$b['id']; $sid=$sz['id'];
        $shHtml->setCellValueByColumnAndRow($colHtml, $rowHtml, $openingB[$bid][$sid]);
        $shHtml->setCellValueByColumnAndRow($colHtml+1, $rowHtml, $receivedB[$bid][$sid]);
        $shHtml->setCellValueByColumnAndRow($colHtml+3, $rowHtml, $soldB[$bid][$sid]);
        $shHtml->setCellValueByColumnAndRow($colHtml+4, $rowHtml, $closingB[$bid][$sid]);
        $colHtml += 5;
    }
    $rowHtml++;
}
$htmlWriter = new \PhpOffice\PhpSpreadsheet\Writer\Html($ssHtml);
$htmlWriter->setPreCalculateFormulas(true);
echo $htmlWriter->generateHTMLAll();
$content = ob_get_clean();
require_once __DIR__ . '/../../includes/layout.php';
?>
