<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../includes/core.php';
if (!isLoggedIn() || getRole() !== 'admin') {
    redirect(BASE_URL . '/login.php');
}
// Master Data Management dashboard links
ob_start();
?>
<div class="d-flex justify-content-between align-items-center mb-4">
  <h1>Master Data Management</h1>
</div>
<div class="row">
  <?php
  $cards = [
    ['title'=>'Liquors','text'=>'Manage all liquor items.','link'=>'liquor.php'],
    ['title'=>'Products','text'=>'Define products with size, price & tax.','link'=>'products.php'],
    ['title'=>'Brands','text'=>'Add and edit liquor brands.','link'=>'brands.php'],
    ['title'=>'Sizes','text'=>'Add and edit liquor sizes.','link'=>'sizes.php'],
    ['title'=>'Categories','text'=>'Add and edit liquor categories.','link'=>'categories.php'],
  ];
  foreach ($cards as $card):
  ?>
    <div class="col-md-4 mb-4">
      <div class="card h-100 text-center">
        <div class="card-body d-flex flex-column">
          <h5 class="card-title"><?= htmlspecialchars($card['title']) ?></h5>
          <p class="card-text flex-grow-1"><?= htmlspecialchars($card['text']) ?></p>
          <a href="<?= BASE_URL ?>/panels/admin/<?= htmlspecialchars($card['link']) ?>" class="btn btn-primary mt-2">Go to <?= htmlspecialchars($card['title']) ?></a>
        </div>
      </div>
    </div>
  <?php endforeach; ?>
</div>
<?php
$content = ob_get_clean();
require_once __DIR__ . '/../../includes/layout.php';
