<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../includes/core.php';
if (!isLoggedIn() || getRole() !== 'admin') redirect(BASE_URL . '/login.php');

$error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $supplier_id = intval($_POST['supplier_id'] ?? 0);
    $purchase_date = $_POST['purchase_date'] ?? date('Y-m-d H:i:s');
    $products = $_POST['product_id'] ?? [];
    $quantities = $_POST['quantity'] ?? [];
    $prices = $_POST['price'] ?? [];
    $taxes = $_POST['tax'] ?? [];

    if (!$supplier_id || empty($products)) {
        $error = 'Supplier and at least one item are required.';
    } else {
        $total_amount = 0;
        $items = [];
        foreach ($products as $i => $pid) {
            $pid = intval($pid);
            $qty = intval($quantities[$i] ?? 0);
            $price = floatval($prices[$i] ?? 0);
            $tax = floatval($taxes[$i] ?? 0);
            if ($pid && $qty > 0) {
                $line_total = $qty * ($price + ($price * $tax / 100));
                $total_amount += $line_total;
                $items[] = ['product_id'=>$pid,'quantity'=>$qty,'price'=>$price,'tax'=>$tax,'total'=>$line_total];
            }
        }
        if (empty($items)) {
            $error = 'At least one valid item is required.';
        }
    }
    if (!$error) {
        // Insert purchase
        $stmt = mysqli_prepare($conn, "INSERT INTO purchases (supplier_id,purchase_date,total_amount,created_by) VALUES (?,?,?,?)");
        $uid = $_SESSION['user_id'];
        mysqli_stmt_bind_param($stmt,'isdi',$supplier_id,$purchase_date,$total_amount,$uid);
        mysqli_stmt_execute($stmt);
        $purchase_id = mysqli_insert_id($conn);
        mysqli_stmt_close($stmt);
        // Insert items & update stock
        foreach ($items as $it) {
            $stmt = mysqli_prepare($conn, "INSERT INTO purchase_items (purchase_id,product_id,quantity,price,tax,total) VALUES (?,?,?,?,?,?)");
            mysqli_stmt_bind_param($stmt,'iiiddd',$purchase_id,$it['product_id'],$it['quantity'],$it['price'],$it['tax'],$it['total']);
            mysqli_stmt_execute($stmt);
            mysqli_stmt_close($stmt);
            $pid = $it['product_id']; $qty = $it['quantity'];
            $res = mysqli_query($conn, "SELECT quantity FROM stock WHERE product_id = $pid");
            if ($row = mysqli_fetch_assoc($res)) {
                mysqli_query($conn, "UPDATE stock SET quantity = quantity + $qty WHERE product_id = $pid");
            } else {
                mysqli_query($conn, "INSERT INTO stock (product_id,quantity) VALUES ($pid,$qty)");
            }
            mysqli_query($conn, "INSERT INTO stock_movements (product_id,counter_id,movement_type,quantity) VALUES ($pid,NULL,'in',$qty)");
        }
        redirect(BASE_URL . '/panels/admin/purchases.php');
    }
}
// Fetch lists
$suppliers = mysqli_fetch_all(mysqli_query($conn,"SELECT id,name FROM suppliers ORDER BY name"),MYSQLI_ASSOC);
$products = mysqli_fetch_all(mysqli_query($conn,"SELECT id,name FROM products ORDER BY name"),MYSQLI_ASSOC);
ob_start();
?>
<h1>New Purchase</h1>
<?php if ($error): ?><div class="alert alert-danger"><?=htmlspecialchars($error)?></div><?php endif; ?>
<form method="POST">
  <div class="row mb-3">
    <div class="col">
      <label class="form-label">Supplier</label>
      <select name="supplier_id" class="form-select" required>
        <option value="">-- Select Supplier --</option>
        <?php foreach ($suppliers as $s): ?>
        <option value="<?=$s['id']?>" <?=($_POST['supplier_id']??'')==$s['id']?'selected':''?>><?=htmlspecialchars($s['name'])?></option>
        <?php endforeach; ?>
      </select>
    </div>
    <div class="col">
      <label class="form-label">Purchase Date</label>
      <input type="datetime-local" name="purchase_date" class="form-control" value="<?=htmlspecialchars($_POST['purchase_date']??date('Y-m-d\TH:i'))?>">
    </div>
  </div>
  <table class="table" id="items_table">
    <thead><tr><th>Product</th><th>Qty</th><th>Price</th><th>Tax %</th><th>Total</th><th></th></tr></thead>
    <tbody>
      <?php
      $old_p = $_POST['product_id']??[''];
      $old_q = $_POST['quantity']??[''];
      $old_price = $_POST['price']??[''];
      $old_tax = $_POST['tax']??[''];
      foreach ($old_p as $i=>$v): ?>
      <tr>
        <td><select name="product_id[]" class="form-select product-select" required><option value="">-- Select --</option><?php foreach($products as $p): ?><option value="<?=$p['id']?>" <?=$v==$p['id']?'selected':''?>><?=htmlspecialchars($p['name'])?></option><?php endforeach; ?></select></td>
        <td><input type="number" name="quantity[]" class="form-control qty-input" value="<?=htmlspecialchars($old_q[$i]??'')?>" min="1" required></td>
        <td><input type="number" step="0.01" name="price[]" class="form-control price-input" value="<?=htmlspecialchars($old_price[$i]??'')?>" required></td>
        <td><input type="number" step="0.01" name="tax[]" class="form-control tax-input" value="<?=htmlspecialchars($old_tax[$i]??'')?>"></td>
        <td><input type="text" class="form-control total-cell" readonly></td>
        <td><button type="button" class="btn btn-danger remove-row">×</button></td>
      </tr>
      <?php endforeach; ?>
    </tbody>
    <tfoot>
      <tr><td colspan="4" class="text-end"><strong>Grand Total:</strong></td><td><input id="grand_total" class="form-control" readonly></td><td><button type="button" id="add_row" class="btn btn-primary">+</button></td></tr>
    </tfoot>
  </table>
  <button class="btn btn-success">Save Purchase</button>
</form>
<script>
function recalcRow(r){var q=parseFloat(r.querySelector('.qty-input').value)||0;var p=parseFloat(r.querySelector('.price-input').value)||0;var t=parseFloat(r.querySelector('.tax-input').value)||0;var tot=q*(p+p*t/100);r.querySelector('.total-cell').value=tot.toFixed(2);}function recalcAll(){var gs=0;document.querySelectorAll('#items_table tbody tr').forEach(function(r){recalcRow(r);gs+=parseFloat(r.querySelector('.total-cell').value)||0});document.getElementById('grand_total').value=gs.toFixed(2);}document.getElementById('add_row').addEventListener('click',function(){var tb=document.querySelector('#items_table tbody');var r=tb.querySelector('tr').cloneNode(true);r.querySelectorAll('input').forEach(i=>i.value='');r.querySelector('.total-cell').value='';tb.appendChild(r)});document.querySelector('#items_table').addEventListener('input',function(e){if(e.target.matches('.qty-input, .price-input, .tax-input'))recalcAll()});document.querySelector('#items_table').addEventListener('click',function(e){if(e.target.matches('.remove-row')&&document.querySelectorAll('#items_table tbody tr').length>1){e.target.closest('tr').remove();recalcAll()}});recalcAll();
</script>
<?php $content=ob_get_clean();require_once __DIR__.'/../../includes/layout.php';
?>
