<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../includes/core.php';
if (!isLoggedIn() || getRole() !== 'admin') redirect(BASE_URL . '/login.php');

// Handle delete
if (isset($_GET['delete'])) {
    $id = intval($_GET['delete']);
    mysqli_query($conn, "DELETE FROM opening_stock WHERE id = $id");
    redirect(BASE_URL . '/panels/admin/opening_stock.php');
}

// Ensure opening_stock table exists
$check = mysqli_query($conn, "SHOW TABLES LIKE 'opening_stock'") or die('Error checking opening_stock table: '.mysqli_error($conn));
if (mysqli_num_rows($check) === 0) {
    $createSQL = "CREATE TABLE `opening_stock` ( `id` INT UNSIGNED NOT NULL AUTO_INCREMENT, `counter_id` INT UNSIGNED NOT NULL, `product_id` INT UNSIGNED NOT NULL, `quantity` INT NOT NULL, `created_at` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP, PRIMARY KEY (`id`), KEY `fk_os_counter` (`counter_id`), KEY `fk_os_product` (`product_id`), CONSTRAINT `fk_os_counter` FOREIGN KEY (`counter_id`) REFERENCES `counters`(`id`) ON DELETE CASCADE, CONSTRAINT `fk_os_product` FOREIGN KEY (`product_id`) REFERENCES `products`(`id`) ON DELETE CASCADE ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci";
    mysqli_query($conn, $createSQL) or die('Error creating opening_stock table: '.mysqli_error($conn));
}
// Fetch opening stock records
$sql = "SELECT os.id, os.counter_id, os.product_id, os.quantity, os.created_at, c.name AS counter_name, p.name AS product_name
        FROM opening_stock os
        LEFT JOIN counters c ON os.counter_id = c.id
        LEFT JOIN products p ON os.product_id = p.id
        ORDER BY os.created_at DESC";
$res = mysqli_query($conn, $sql) or die('Error fetching opening stock: '.mysqli_error($conn));
$rows = mysqli_fetch_all($res, MYSQLI_ASSOC);

ob_start();
?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <h1>Opening Stock</h1>
  <a href="<?= BASE_URL ?>/panels/admin/opening_stock_form.php" class="btn btn-primary">Add Opening Stock</a>
</div>
<table class="table table-bordered table-striped">
  <thead>
    <tr><th>ID</th><th>Counter</th><th>Product</th><th>Quantity</th><th>Created At</th><th>Actions</th></tr>
  </thead>
  <tbody>
    <?php foreach ($rows as $r): ?>
    <tr>
      <td><?= $r['id'] ?></td>
      <td><?= htmlspecialchars($r['counter_name'] ?? '') ?></td>
      <td><?= htmlspecialchars($r['product_name'] ?? '') ?></td>
      <td><?= $r['quantity'] ?></td>
      <td><?= $r['created_at'] ?></td>
      <td>
        <a href="<?= BASE_URL ?>/panels/admin/opening_stock_form.php?id=<?= $r['id'] ?>" class="btn btn-sm btn-warning">Edit</a>
        <a href="<?= BASE_URL ?>/panels/admin/opening_stock.php?delete=<?= $r['id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('Delete this record?')">Delete</a>
      </td>
    </tr>
    <?php endforeach; ?>
  </tbody>
</table>
<?php
$content = ob_get_clean();
require_once __DIR__ . '/../../includes/layout.php';
?>
