<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../includes/core.php';
if (!isLoggedIn() || getRole() !== 'admin') redirect(BASE_URL . '/login.php');

// Get product ID
$id = intval($_GET['id'] ?? 0);
if (!$id) redirect(BASE_URL . '/panels/admin/prices_tax.php');

// Initialize
$name = '';
$price = '';
$tax = '';
$error = '';

// On POST, update price & tax
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $price = $_POST['price'] ?? '';
    $tax = $_POST['tax'] ?? '';
    if ($price === '' || $tax === '') {
        $error = 'Please provide both price and tax.';
    } elseif (!is_numeric($price) || !is_numeric($tax)) {
        $error = 'Price and tax must be numeric.';
    } else {
        $stmt = mysqli_prepare($conn, "UPDATE products SET price = ?, tax = ? WHERE id = ?");
        mysqli_stmt_bind_param($stmt, 'ddi', $price, $tax, $id);
        mysqli_stmt_execute($stmt);
        mysqli_stmt_close($stmt);
        redirect(BASE_URL . '/panels/admin/prices_tax.php');
    }
} else {
    // Fetch existing product details
    $stmt = mysqli_prepare($conn, "SELECT name, price, tax FROM products WHERE id = ?");
    mysqli_stmt_bind_param($stmt, 'i', $id);
    mysqli_stmt_execute($stmt);
    mysqli_stmt_bind_result($stmt, $name, $price, $tax);
    mysqli_stmt_fetch($stmt);
    mysqli_stmt_close($stmt);
}

ob_start();
?>
<h1>Edit Price & Tax for <?= htmlspecialchars($name) ?></h1>
<?php if ($error): ?>
  <div class="alert alert-danger"><?= htmlspecialchars($error) ?></div>
<?php endif; ?>
<form method="POST">
  <div class="mb-3">
    <label class="form-label">Price</label>
    <input type="number" step="0.01" name="price" class="form-control" value="<?= htmlspecialchars($price) ?>" required>
  </div>
  <div class="mb-3">
    <label class="form-label">Tax (%)</label>
    <input type="number" step="0.01" name="tax" class="form-control" value="<?= htmlspecialchars($tax) ?>" required>
  </div>
  <button class="btn btn-success">Save</button>
  <a href="<?= BASE_URL ?>/panels/admin/prices_tax.php" class="btn btn-secondary">Cancel</a>
</form>
<?php
$content = ob_get_clean();
require_once __DIR__ . '/../../includes/layout.php';
?>
