<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../includes/core.php';
if (!isLoggedIn() || getRole() !== 'admin') redirect(BASE_URL . '/login.php');

$id = intval($_GET['id'] ?? 0);
$name = '';
$brand_id = 0;
$category_id = 0;
$size_id = 0;
$price = '';
$tax = '';
// Fetch options
$brands = mysqli_fetch_all(mysqli_query($conn, "SELECT id, name FROM brands ORDER BY name"), MYSQLI_ASSOC);
$categories = mysqli_fetch_all(mysqli_query($conn, "SELECT id, name FROM categories ORDER BY name"), MYSQLI_ASSOC);
$sizes = mysqli_fetch_all(mysqli_query($conn, "SELECT id, name FROM sizes ORDER BY name"), MYSQLI_ASSOC);
// Load existing
if ($id) {
    $stmt = mysqli_prepare($conn, "SELECT name, brand_id, category_id, size_id, price, tax FROM products WHERE id = ?");
    mysqli_stmt_bind_param($stmt, 'i', $id);
    mysqli_stmt_execute($stmt);
    mysqli_stmt_bind_result($stmt, $name, $brand_id, $category_id, $size_id, $price, $tax);
    mysqli_stmt_fetch($stmt);
    mysqli_stmt_close($stmt);
}
$error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = trim($_POST['name']);
    $brand_id = intval($_POST['brand_id']);
    $category_id = intval($_POST['category_id']);
    $size_id = intval($_POST['size_id']);
    $price = $_POST['price'];
    $tax = $_POST['tax'];
    if ($name !== '' && $price !== '' && $tax !== '') {
        if ($id) {
            $stmt = mysqli_prepare($conn, "UPDATE products SET name=?, brand_id=?, category_id=?, size_id=?, price=?, tax=? WHERE id=?");
            mysqli_stmt_bind_param($stmt, 'siiiidi', $name, $brand_id, $category_id, $size_id, $price, $tax, $id);
        } else {
            $stmt = mysqli_prepare($conn, "INSERT INTO products (name, brand_id, category_id, size_id, price, tax) VALUES (?, ?, ?, ?, ?, ?)");
            mysqli_stmt_bind_param($stmt, 'siiiid', $name, $brand_id, $category_id, $size_id, $price, $tax);
        }
        mysqli_stmt_execute($stmt);
        mysqli_stmt_close($stmt);
        redirect(BASE_URL . '/panels/admin/products.php');
    } else {
        $error = 'Please fill all required fields.';
    }
}
ob_start();
?>
<h1><?= $id ? 'Edit' : 'Add' ?> Product</h1>
<?php if ($error): ?>
  <div class="alert alert-danger"><?= htmlspecialchars($error) ?></div>
<?php endif; ?>
<form method="POST">
  <div class="mb-3">
    <label class="form-label">Product Name</label>
    <input type="text" name="name" class="form-control" value="<?= htmlspecialchars($name) ?>" required>
  </div>
  <div class="mb-3">
    <label class="form-label">Brand</label>
    <select name="brand_id" class="form-select">
      <option value="">-- Select Brand --</option>
      <?php foreach ($brands as $b): ?>
      <option value="<?= $b['id'] ?>" <?= $b['id']==$brand_id?'selected':'' ?>><?= htmlspecialchars($b['name']) ?></option>
      <?php endforeach; ?>
    </select>
  </div>
  <div class="mb-3">
    <label class="form-label">Category</label>
    <select name="category_id" class="form-select">
      <option value="">-- Select Category --</option>
      <?php foreach ($categories as $c): ?>
      <option value="<?= $c['id'] ?>" <?= $c['id']==$category_id?'selected':'' ?>><?= htmlspecialchars($c['name']) ?></option>
      <?php endforeach; ?>
    </select>
  </div>
  <div class="mb-3">
    <label class="form-label">Size</label>
    <select name="size_id" class="form-select">
      <option value="">-- Select Size --</option>
      <?php foreach ($sizes as $s): ?>
      <option value="<?= $s['id'] ?>" <?= $s['id']==$size_id?'selected':'' ?>><?= htmlspecialchars($s['name']) ?></option>
      <?php endforeach; ?>
    </select>
  </div>
  <div class="mb-3">
    <label class="form-label">Price</label>
    <input type="number" name="price" class="form-control" step="0.01" value="<?= htmlspecialchars($price) ?>" required>
  </div>
  <div class="mb-3">
    <label class="form-label">Tax %</label>
    <input type="number" name="tax" class="form-control" step="0.01" value="<?= htmlspecialchars($tax) ?>" required>
  </div>
  <button class="btn btn-success"><?= $id ? 'Update' : 'Create' ?></button>
  <a href="<?= BASE_URL ?>/panels/admin/products.php" class="btn btn-secondary">Cancel</a>
</form>
<?php
$content = ob_get_clean();
require_once __DIR__ . '/../../includes/layout.php';
?>
