<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../includes/core.php';
if (!isLoggedIn() || getRole() !== 'admin') redirect(BASE_URL . '/login.php');

// Ensure purchase_payments table exists
$create = "CREATE TABLE IF NOT EXISTS `purchase_payments` (
  `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `purchase_id` INT UNSIGNED NOT NULL,
  `payment_date` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `amount` DECIMAL(10,2) NOT NULL,
  `payment_method` ENUM('cash','card','cheque','online') NOT NULL DEFAULT 'cash',
  `remarks` TEXT,
  `created_by` INT UNSIGNED DEFAULT NULL,
  `created_at` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_pp_purchase` (`purchase_id`),
  KEY `fk_pp_user` (`created_by`),
  CONSTRAINT `fk_pp_purchase` FOREIGN KEY (`purchase_id`) REFERENCES `purchases`(`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_pp_user` FOREIGN KEY (`created_by`) REFERENCES `users`(`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci";
mysqli_query($conn, $create) or die('Error ensuring purchase_payments table: '.mysqli_error($conn));

// Ensure remarks column exists
$col2 = mysqli_query($conn, "SHOW COLUMNS FROM `purchase_payments` LIKE 'remarks'") or die('Error checking remarks column: '.mysqli_error($conn));
if (mysqli_num_rows($col2) === 0) {
    mysqli_query($conn, "ALTER TABLE `purchase_payments` ADD COLUMN `remarks` TEXT") or die('Error adding remarks column: '.mysqli_error($conn));
}
// Determine if remarks column is present
$hasRemarks = mysqli_num_rows($col2) > 0;

// Ensure payment_method column exists
$col = mysqli_query($conn, "SHOW COLUMNS FROM `purchase_payments` LIKE 'payment_method'") or die('Error checking payment_method column: '.mysqli_error($conn));
if (mysqli_num_rows($col) === 0) {
    mysqli_query($conn, "ALTER TABLE `purchase_payments` ADD COLUMN `payment_method` ENUM('cash','card','cheque','online') NOT NULL DEFAULT 'cash'") or die('Error adding payment_method column: '.mysqli_error($conn));
}

// Ensure created_by column exists
$col3 = mysqli_query($conn, "SHOW COLUMNS FROM `purchase_payments` LIKE 'created_by'") or die('Error checking created_by column: '.mysqli_error($conn));
if (mysqli_num_rows($col3) === 0) {
    mysqli_query($conn, "ALTER TABLE `purchase_payments` ADD COLUMN `created_by` INT UNSIGNED DEFAULT NULL") or die('Error adding created_by column: '.mysqli_error($conn));
}

// Determine if payment_method column is present
$hasPM = mysqli_num_rows($col) > 0;

// Handle delete
if (isset($_GET['delete'])) {
    $id = intval($_GET['delete']);
    mysqli_query($conn, "DELETE FROM purchase_payments WHERE id = $id") or die('Error deleting payment: '.mysqli_error($conn));
    redirect(BASE_URL . '/panels/admin/purchase_payments.php');
}

// Fetch payments
// Build query with optional payment_method and remarks
$fields = "pp.id, pp.payment_date, pp.amount";
if ($hasPM) { $fields .= ", pp.payment_method"; }
if ($hasRemarks) { $fields .= ", pp.remarks"; }
$fields .= ", p.id AS purchase_id, COALESCE(s.name,'') AS supplier_name";
if ($hasPM) { $fields .= ", COALESCE(u.username,'') AS created_by"; }
$sql = "SELECT $fields
    FROM purchase_payments pp
    LEFT JOIN purchases p ON pp.purchase_id = p.id
    LEFT JOIN suppliers s ON p.supplier_id = s.id";
if ($hasPM) { $sql .= " LEFT JOIN users u ON pp.created_by = u.id"; }
$sql .= " ORDER BY pp.payment_date DESC";
$res = mysqli_query($conn, $sql) or die('Error fetching payments: '.mysqli_error($conn));
$rows = mysqli_fetch_all($res, MYSQLI_ASSOC);

ob_start();
?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <h1>Purchase Payments</h1>
  <a href="<?= BASE_URL ?>/panels/admin/purchase_payment_form.php" class="btn btn-primary">Add Payment</a>
</div>
<table class="table table-bordered table-striped">
  <thead>
    <tr>
      <th>ID</th>
      <th>Purchase ID</th>
      <th>Supplier</th>
      <th>Date</th>
      <th>Amount</th>
      <?php if ($hasPM): ?>
      <th>Method</th>
      <?php endif; ?>
      <?php if ($hasRemarks): ?>
      <th>Remarks</th>
      <?php endif; ?>
      <?php if ($hasPM): ?>
      <th>Created By</th>
      <?php endif; ?>
      <th>Actions</th>
    </tr>
  </thead>
  <tbody>
    <?php foreach ($rows as $r): ?>
    <tr>
      <td><?= $r['id'] ?></td>
      <td><?= $r['purchase_id'] ?></td>
      <td><?= htmlspecialchars($r['supplier_name']) ?></td>
      <td><?= $r['payment_date'] ?></td>
      <td><?= number_format($r['amount'],2) ?></td>
      <?php if ($hasPM): ?>
      <td><?= ucfirst($r['payment_method']) ?></td>
      <?php endif; ?>
      <?php if ($hasRemarks): ?>
      <td><?= htmlspecialchars($r['remarks']) ?></td>
      <?php endif; ?>
      <?php if ($hasPM): ?>
      <td><?= htmlspecialchars($r['created_by']) ?></td>
      <?php endif; ?>
      <td>
        <a href="<?= BASE_URL ?>/panels/admin/purchase_payments.php?delete=<?= $r['id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('Delete this payment?')">Delete</a>
      </td>
    </tr>
    <?php endforeach; ?>
  </tbody>
</table>
<?php
$content = ob_get_clean();
require_once __DIR__ . '/../../includes/layout.php';
?>
