<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../includes/core.php';
if (!isLoggedIn() || getRole() !== 'admin') redirect(BASE_URL . '/login.php');

// Ensure sales table exists
$createSales = "CREATE TABLE IF NOT EXISTS `sales` (
  `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `counter_id` INT UNSIGNED DEFAULT NULL,
  `sale_date` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `total_amount` DECIMAL(10,2) NOT NULL,
  `created_by` INT UNSIGNED DEFAULT NULL,
  `created_at` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_sales_counter` (`counter_id`),
  KEY `fk_sales_user` (`created_by`),
  CONSTRAINT `fk_sales_counter` FOREIGN KEY (`counter_id`) REFERENCES `counters`(`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_sales_user` FOREIGN KEY (`created_by`) REFERENCES `users`(`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci";
mysqli_query($conn, $createSales) or die('Error ensuring sales table: '.mysqli_error($conn));

// Ensure sales_items table exists
$createItems = "CREATE TABLE IF NOT EXISTS `sales_items` (
  `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `sale_id` INT UNSIGNED NOT NULL,
  `product_id` INT UNSIGNED NOT NULL,
  `quantity` INT NOT NULL,
  `price` DECIMAL(10,2) NOT NULL,
  `tax` DECIMAL(5,2) NOT NULL DEFAULT 0,
  `total` DECIMAL(10,2) NOT NULL,
  `created_at` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_si_sale` (`sale_id`),
  KEY `fk_si_product` (`product_id`),
  CONSTRAINT `fk_si_sale` FOREIGN KEY (`sale_id`) REFERENCES `sales`(`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_si_product` FOREIGN KEY (`product_id`) REFERENCES `products`(`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci";
mysqli_query($conn, $createItems) or die('Error ensuring sales_items table: '.mysqli_error($conn));

// Handle delete
if (isset($_GET['delete'])) {
    $id = intval($_GET['delete']);
    mysqli_query($conn, "DELETE FROM sales WHERE id = $id") or die('Error deleting sale: '.mysqli_error($conn));
    redirect(BASE_URL . '/panels/admin/sales_overview.php');
}

// Fetch sales overview
$sql = "SELECT s.id, s.sale_date, COALESCE(c.name, '') AS counter_name, s.total_amount, COALESCE(u.username,'') AS created_by
        FROM sales s
        LEFT JOIN counters c ON s.counter_id = c.id
        LEFT JOIN users u ON s.created_by = u.id
        ORDER BY s.sale_date DESC";
$res = mysqli_query($conn, $sql) or die('Error fetching sales overview: '.mysqli_error($conn));
$rows = mysqli_fetch_all($res, MYSQLI_ASSOC);

ob_start();
?>
<h1>Sales Overview</h1>
<table class="table table-bordered table-striped">
  <thead>
    <tr>
      <th>ID</th>
      <th>Date</th>
      <th>Counter</th>
      <th>Total Amount</th>
      <th>Created By</th>
      <th>Actions</th>
    </tr>
  </thead>
  <tbody>
    <?php foreach ($rows as $r): ?>
    <tr>
      <td><?= $r['id'] ?></td>
      <td><?= $r['sale_date'] ?></td>
      <td><?= htmlspecialchars($r['counter_name']) ?></td>
      <td><?= number_format($r['total_amount'],2) ?></td>
      <td><?= htmlspecialchars($r['created_by']) ?></td>
      <td>
        <a href="<?= BASE_URL ?>/panels/admin/sales_overview.php?delete=<?= $r['id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('Delete this sale?')">Delete</a>
      </td>
    </tr>
    <?php endforeach; ?>
  </tbody>
</table>
<?php
$content = ob_get_clean();
require_once __DIR__ . '/../../includes/layout.php';
?>
