<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../includes/core.php';
if (!isLoggedIn() || getRole() !== 'admin') {
    redirect(BASE_URL . '/login.php');
}

$id = intval($_GET['id'] ?? 0);
$name = '';
if ($id) {
    $stmt = mysqli_prepare($conn, "SELECT name FROM sizes WHERE id = ?");
    mysqli_stmt_bind_param($stmt, 'i', $id);
    mysqli_stmt_execute($stmt);
    mysqli_stmt_bind_result($stmt, $name);
    mysqli_stmt_fetch($stmt);
    mysqli_stmt_close($stmt);
}
$error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = trim($_POST['name']);
    if ($name) {
        if ($id) {
            $stmt = mysqli_prepare($conn, "UPDATE sizes SET name = ? WHERE id = ?");
            mysqli_stmt_bind_param($stmt, 'si', $name, $id);
        } else {
            $stmt = mysqli_prepare($conn, "INSERT INTO sizes (name) VALUES (?)");
            mysqli_stmt_bind_param($stmt, 's', $name);
        }
        mysqli_stmt_execute($stmt);
        mysqli_stmt_close($stmt);
        redirect(BASE_URL . '/panels/admin/sizes.php');
    } else {
        $error = 'Size name cannot be empty.';
    }
}
ob_start();
?>
<h1><?= $id ? 'Edit' : 'Add' ?> Size</h1>
<?php if ($error): ?>
  <div class="alert alert-danger"><?= htmlspecialchars($error) ?></div>
<?php endif; ?>
<form method="POST">
  <div class="mb-3">
    <label class="form-label">Size Name</label>
    <input type="text" name="name" class="form-control" value="<?= htmlspecialchars($name) ?>" required>
  </div>
  <button class="btn btn-success"><?= $id ? 'Update' : 'Create' ?></button>
  <a href="<?= BASE_URL ?>/panels/admin/sizes.php" class="btn btn-secondary">Cancel</a>
</form>
<?php
$content = ob_get_clean();
require_once __DIR__ . '/../../includes/layout.php';
?>
