<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../includes/core.php';
if (!isLoggedIn() || getRole() !== 'admin') redirect(BASE_URL . '/login.php');

// Delete
if (isset($_GET['delete'])) {
    $id = intval($_GET['delete']);
    mysqli_query($conn, "DELETE FROM sizes WHERE id = $id");
    redirect(BASE_URL . '/panels/admin/sizes.php');
}
// Fetch
$res = mysqli_query($conn, "SELECT * FROM sizes ORDER BY name");
$sizes = mysqli_fetch_all($res, MYSQLI_ASSOC);
ob_start();
?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <h1>Sizes</h1>
  <a href="<?= BASE_URL ?>/panels/admin/size_form.php" class="btn btn-primary">Add Size</a>
</div>
<table class="table table-bordered table-striped">
  <thead><tr><th>ID</th><th>Name</th><th>Actions</th></tr></thead>
  <tbody>
    <?php foreach ($sizes as $s): ?>
    <tr>
      <td><?= $s['id'] ?></td>
      <td><?= htmlspecialchars($s['name']) ?></td>
      <td>
        <a href="<?= BASE_URL ?>/panels/admin/size_form.php?id=<?= $s['id'] ?>" class="btn btn-sm btn-warning">Edit</a>
        <a href="<?= BASE_URL ?>/panels/admin/sizes.php?delete=<?= $s['id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('Delete this size?')">Delete</a>
      </td>
    </tr>
    <?php endforeach; ?>
  </tbody>
</table>
<?php
$content = ob_get_clean();
require_once __DIR__ . '/../../includes/layout.php';
