<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../includes/core.php';
if (!isLoggedIn() || getRole() !== 'admin') redirect(BASE_URL . '/login.php');

// Initialize
$id = intval($_GET['id'] ?? 0);
$counter_id = 0;
$product_id = 0;
$adjustment_type = 'in';
$quantity = '';
$remarks = '';
$error = '';

// Fetch lists
$counters = mysqli_fetch_all(mysqli_query($conn, "SELECT id, name FROM counters WHERE is_active=1 ORDER BY name"), MYSQLI_ASSOC);
$products = mysqli_fetch_all(mysqli_query($conn, "SELECT id, name FROM products ORDER BY name"), MYSQLI_ASSOC);

// Load existing
if ($id) {
    $stmt = mysqli_prepare($conn, "SELECT counter_id, product_id, adjustment_type, quantity, remarks FROM stock_adjustments WHERE id = ?");
    mysqli_stmt_bind_param($stmt, 'i', $id);
    mysqli_stmt_execute($stmt);
    mysqli_stmt_bind_result($stmt, $counter_id, $product_id, $adjustment_type, $quantity, $remarks);
    mysqli_stmt_fetch($stmt);
    mysqli_stmt_close($stmt);
}

// Handle POST
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $counter_id = intval($_POST['counter_id'] ?? 0);
    $product_id = intval($_POST['product_id'] ?? 0);
    $adjustment_type = $_POST['adjustment_type'] ?? 'in';
    $quantity = intval($_POST['quantity'] ?? 0);
    $remarks = trim($_POST['remarks'] ?? '');
    $userId = $_SESSION['user_id'];

    if (!$counter_id || !$product_id) {
        $error = 'Counter and Product are required.';
    } elseif ($quantity <= 0) {
        $error = 'Quantity must be positive.';
    }

    if (!$error) {
        if ($id) {
            $stmt = mysqli_prepare($conn, "UPDATE stock_adjustments SET counter_id=?, product_id=?, adjustment_type=?, quantity=?, remarks=?, created_by=? WHERE id=?");
            mysqli_stmt_bind_param($stmt, 'iisiisi', $counter_id, $product_id, $adjustment_type, $quantity, $remarks, $userId, $id);
        } else {
            $stmt = mysqli_prepare($conn, "INSERT INTO stock_adjustments (counter_id,product_id,adjustment_type,quantity,remarks,created_by) VALUES (?,?,?,?,?,?)");
            mysqli_stmt_bind_param($stmt, 'iisisi', $counter_id, $product_id, $adjustment_type, $quantity, $remarks, $userId);
        }
        mysqli_stmt_execute($stmt) or die('Error saving adjustment: '.mysqli_error($conn));
        mysqli_stmt_close($stmt);
        redirect(BASE_URL . '/panels/admin/stock_adjustments.php');
    }
}

ob_start();
?>
<h1><?= $id ? 'Edit' : 'Add' ?> Stock Adjustment</h1>
<?php if ($error): ?>
  <div class="alert alert-danger"><?= htmlspecialchars($error) ?></div>
<?php endif; ?>
<form method="POST">
  <div class="mb-3">
    <label class="form-label">Counter</label>
    <select name="counter_id" class="form-select" required>
      <option value="">-- Select Counter --</option>
      <?php foreach ($counters as $c): ?>
        <option value="<?= $c['id'] ?>"<?= $c['id']==$counter_id?' selected':'' ?>><?= htmlspecialchars($c['name']) ?></option>
      <?php endforeach; ?>
    </select>
  </div>
  <div class="mb-3">
    <label class="form-label">Product</label>
    <select name="product_id" class="form-select" required>
      <option value="">-- Select Product --</option>
      <?php foreach ($products as $p): ?>
        <option value="<?= $p['id'] ?>"<?= $p['id']==$product_id?' selected':'' ?>><?= htmlspecialchars($p['name']) ?></option>
      <?php endforeach; ?>
    </select>
  </div>
  <div class="mb-3">
    <label class="form-label">Type</label>
    <select name="adjustment_type" class="form-select">
      <option value="in"<?= $adjustment_type=='in'?' selected':'' ?>>In</option>
      <option value="out"<?= $adjustment_type=='out'?' selected':'' ?>>Out</option>
    </select>
  </div>
  <div class="mb-3">
    <label class="form-label">Quantity</label>
    <input type="number" name="quantity" class="form-control" value="<?= htmlspecialchars($quantity) ?>" min="1" required>
  </div>
  <div class="mb-3">
    <label class="form-label">Remarks</label>
    <textarea name="remarks" class="form-control"><?= htmlspecialchars($remarks) ?></textarea>
  </div>
  <button class="btn btn-success"><?= $id ? 'Update' : 'Create' ?></button>
  <a href="<?= BASE_URL ?>/panels/admin/stock_adjustments.php" class="btn btn-secondary">Cancel</a>
</form>
<?php
$content = ob_get_clean();
require_once __DIR__ . '/../../includes/layout.php';
?>
