<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../includes/core.php';
if (!isLoggedIn() || getRole() !== 'admin') redirect(BASE_URL . '/login.php');

// Fetch stock movement history
$sql = "SELECT sm.id, p.name AS product_name,
        COALESCE(c.name, 'Godown') AS location,
        sm.movement_type, sm.quantity, sm.created_at
        FROM stock_movements sm
        LEFT JOIN products p ON sm.product_id = p.id
        LEFT JOIN counters c ON sm.counter_id = c.id
        ORDER BY sm.created_at DESC";
$res = mysqli_query($conn, $sql) or die('Error fetching stock history: '.mysqli_error($conn));
$rows = mysqli_fetch_all($res, MYSQLI_ASSOC);

ob_start();
?>
<h1>Stock Movement History</h1>
<table class="table table-bordered table-striped">
  <thead>
    <tr>
      <th>ID</th>
      <th>Product</th>
      <th>Location</th>
      <th>Type</th>
      <th>Quantity</th>
      <th>Date/Time</th>
    </tr>
  </thead>
  <tbody>
    <?php foreach ($rows as $r): ?>
    <tr>
      <td><?= $r['id'] ?></td>
      <td><?= htmlspecialchars($r['product_name']) ?></td>
      <td><?= htmlspecialchars($r['location']) ?></td>
      <td><?= ucfirst($r['movement_type']) ?></td>
      <td><?= $r['quantity'] ?></td>
      <td><?= $r['created_at'] ?></td>
    </tr>
    <?php endforeach; ?>
  </tbody>
</table>
<?php
$content = ob_get_clean();
require_once __DIR__ . '/../../includes/layout.php';
?>
