<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../includes/core.php';
if (!isLoggedIn() || getRole() !== 'admin') redirect(BASE_URL . '/login.php');

// Handle delete
if (isset($_GET['delete'])) {
    $id = intval($_GET['delete']);
    mysqli_query($conn, "DELETE FROM `tables` WHERE id = $id");
    redirect(BASE_URL . '/panels/admin/tables.php');
}

// Fetch tables with floor names
$sql = "SELECT t.id, t.table_number, t.capacity, f.name AS floor_name
        FROM `tables` t
        JOIN floors f ON t.floor_id = f.id
        ORDER BY f.name, t.table_number";
$res = mysqli_query($conn, $sql);
$tables = mysqli_fetch_all($res, MYSQLI_ASSOC);

ob_start();
?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <h1>Tables</h1>
  <a href="<?= BASE_URL ?>/panels/admin/table_form.php" class="btn btn-primary">Add Table</a>
</div>
<table class="table table-bordered table-striped">
  <thead>
    <tr><th>ID</th><th>Floor</th><th>Table Number</th><th>Capacity</th><th>Actions</th></tr>
  </thead>
  <tbody>
    <?php foreach ($tables as $tbl): ?>
    <tr>
      <td><?= $tbl['id'] ?></td>
      <td><?= htmlspecialchars($tbl['floor_name']) ?></td>
      <td><?= htmlspecialchars($tbl['table_number']) ?></td>
      <td><?= intval($tbl['capacity']) ?></td>
      <td>
        <a href="<?= BASE_URL ?>/panels/admin/table_form.php?id=<?= $tbl['id'] ?>" class="btn btn-sm btn-warning">Edit</a>
        <a href="<?= BASE_URL ?>/panels/admin/tables.php?delete=<?= $tbl['id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('Delete this table?')">Delete</a>
      </td>
    </tr>
    <?php endforeach; ?>
  </tbody>
</table>
<?php
$content = ob_get_clean();
require_once __DIR__ . '/../../includes/layout.php';
?>
