<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../includes/core.php';
if (!isLoggedIn() || getRole() !== 'manager') redirect(BASE_URL . '/login.php');
// Get assigned counter and name
$res = mysqli_query($conn, "SELECT u.assigned_counter_id, c.name AS counter_name FROM users u LEFT JOIN counters c ON u.assigned_counter_id=c.id WHERE u.id={$_SESSION['user_id']}");
$row = mysqli_fetch_assoc($res);
$counterID = intval($row['assigned_counter_id'] ?? 0);
$counterName = $row['counter_name'] ?? 'N/A';
// Fetch stock
$sql = "SELECT p.name AS product, b.name AS brand, cat.name AS category, s.name AS size, cs.quantity
        FROM counter_stock cs
        JOIN products p ON cs.product_id=p.id
        LEFT JOIN brands b ON p.brand_id=b.id
        LEFT JOIN categories cat ON p.category_id=cat.id
        LEFT JOIN sizes s ON p.size_id=s.id
        WHERE cs.counter_id=$counterID
        ORDER BY p.name";
$res = mysqli_query($conn, $sql) or die(mysqli_error($conn));
$stock = mysqli_fetch_all($res, MYSQLI_ASSOC);
ob_start();
?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <h1 class="h2">Counter Stock</h1>
  <small class="text-muted">Counter: <?= htmlspecialchars($counterName) ?></small>
</div>
<table class="table table-striped">
  <thead><tr><th>Product</th><th>Brand</th><th>Category</th><th>Size</th><th>Qty</th></tr></thead>
  <tbody>
    <?php foreach ($stock as $r): ?>
    <tr class="<?= $r['quantity'] < 10 ? 'table-danger' : '' ?>">
      <td><?= htmlspecialchars($r['product']) ?></td>
      <td><?= htmlspecialchars($r['brand']) ?></td>
      <td><?= htmlspecialchars($r['category']) ?></td>
      <td><?= htmlspecialchars($r['size']) ?></td>
      <td><?= intval($r['quantity']) ?></td>
    </tr>
    <?php endforeach; ?>
  </tbody>
</table>
<?php
$content = ob_get_clean();
require_once __DIR__ . '/../../includes/layout.php';
?>
