<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../includes/core.php';
if (!isLoggedIn() || getRole() !== 'manager') redirect(BASE_URL . '/login.php');
// Ensure dispatches has received columns
$cols = [
    'received_at' => 'DATETIME',
    'received_by' => 'INT UNSIGNED',
];
foreach ($cols as $col => $def) {
    $chk = mysqli_query($conn, "SHOW COLUMNS FROM `dispatches` LIKE '$col'");
    if (mysqli_num_rows($chk) === 0) {
        mysqli_query($conn, "ALTER TABLE `dispatches` ADD COLUMN `$col` $def") or die(mysqli_error($conn));
    }
}
// Handle confirm reception
if (isset($_GET['confirm'], $_GET['id'])) {
    $did = intval($_GET['id']);
    mysqli_query($conn, "UPDATE dispatches SET received_by={$_SESSION['user_id']}, received_at=NOW() WHERE id=$did") or die(mysqli_error($conn));
    redirect(BASE_URL . '/panels/manager/dispatch_monitoring.php');
}
// Get assigned counter
$res = mysqli_query($conn, "SELECT assigned_counter_id FROM users WHERE id={$_SESSION['user_id']}");
$counterID = intval(mysqli_fetch_assoc($res)['assigned_counter_id'] ?? 0);
// Fetch dispatches for this counter
$sql = "SELECT d.id, p.name AS product, sr.quantity, d.dispatched_at, d.received_at,
        CONCAT(u1.full_name,' (',u1.username,')') AS dispatched_by,
        IF(d.received_by IS NOT NULL, CONCAT(u2.full_name,' (',u2.username,')'), '') AS received_by
    FROM dispatches d
    JOIN stock_requests sr ON d.stock_request_id=sr.id
    JOIN products p ON sr.product_id=p.id
    LEFT JOIN users u1 ON d.dispatched_by=u1.id
    LEFT JOIN users u2 ON d.received_by=u2.id
    WHERE sr.counter_id=$counterID
    ORDER BY d.dispatched_at DESC";
$res = mysqli_query($conn, $sql) or die(mysqli_error($conn));
ob_start();
?>
<h1 class="h2 mb-4">Dispatch Monitoring</h1>
<table class="table table-striped">
  <thead>
    <tr><th>ID</th><th>Product</th><th>Qty</th><th>Dispatched At</th><th>By</th><th>Received At</th><th>Received By</th><th>Action</th></tr>
  </thead>
  <tbody>
  <?php while($r=mysqli_fetch_assoc($res)): ?>
    <tr>
      <td><?= $r['id'] ?></td>
      <td><?= htmlspecialchars($r['product']) ?></td>
      <td><?= $r['quantity'] ?></td>
      <td><?= $r['dispatched_at'] ?></td>
      <td><?= htmlspecialchars($r['dispatched_by']) ?></td>
      <td><?= $r['received_at'] ?? '-' ?></td>
      <td><?= htmlspecialchars($r['received_by']) ?></td>
      <td>
        <?php if (empty($r['received_at'])): ?>
        <a href="?confirm=1&id=<?= $r['id'] ?>" class="btn btn-sm btn-success">Confirm Received</a>
        <?php else: ?>
        <span class="text-muted">Confirmed</span>
        <?php endif; ?>
      </td>
    </tr>
  <?php endwhile; ?>
  </tbody>
</table>
<?php
$content = ob_get_clean();
require_once __DIR__ . '/../../includes/layout.php';
?>
