<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../includes/core.php';
if (!isLoggedIn() || getRole() !== 'manager') redirect(BASE_URL . '/login.php');
// Assigned counter
$res = mysqli_query($conn, "SELECT assigned_counter_id FROM users WHERE id={$_SESSION['user_id']}");
$counterID = intval(mysqli_fetch_assoc($res)['assigned_counter_id'] ?? 0);
// Filters
$from = $_GET['from'] ?? '';
$to = $_GET['to'] ?? '';
$where = ["counter_id=$counterID"];
if ($from) $where[] = "DATE(sale_date)>= '".mysqli_real_escape_string($conn,$from)."'";
if ($to) $where[] = "DATE(sale_date)<= '".mysqli_real_escape_string($conn,$to)."'";
$w = implode(' AND ', $where);
// Fetch invoices
$sql = "SELECT id, sale_date, total_amount, created_by FROM sales WHERE $w ORDER BY sale_date DESC";
$res = mysqli_query($conn, $sql) or die(mysqli_error($conn));
// Export CSV
if (isset($_GET['export']) && $_GET['export']==='csv') {
    header('Content-Type: text/csv');
    header('Content-Disposition: attachment; filename="invoices.csv"');
    $out = fopen('php://output','w');
    fputcsv($out, ['ID','Date','Total','Staff']);
    while($r = mysqli_fetch_assoc($res)) {
        $staff = mysqli_fetch_assoc(mysqli_query($conn,"SELECT full_name FROM users WHERE id={$r['created_by']}"))['full_name'] ?? '';
        fputcsv($out, [$r['id'],$r['sale_date'],number_format($r['total_amount'],2),$staff]);
    }
    exit;
}
ob_start();
?>
<h1 class="h2 mb-4">Invoice Tracker</h1>
<form method="GET" class="row g-3 mb-4">
  <div class="col-md-3"><input type="date" name="from" value="<?=htmlspecialchars($from)?>" class="form-control"></div>
  <div class="col-md-3"><input type="date" name="to"   value="<?=htmlspecialchars($to)?>" class="form-control"></div>
  <div class="col-md-6">
    <button class="btn btn-primary">Filter</button>
    <a href="?<?=htmlspecialchars($_SERVER['QUERY_STRING'])?>&export=csv" class="btn btn-secondary">Export CSV</a>
  </div>
</form>
<table class="table table-striped">
  <thead><tr><th>ID</th><th>Date</th><th>Total</th><th>Staff</th></tr></thead>
  <tbody>
    <?php foreach(mysqli_query($conn, $sql) as $r):
      $staff = mysqli_fetch_assoc(mysqli_query($conn,"SELECT full_name FROM users WHERE id={$r['created_by']}"))['full_name'] ?? '';
    ?>
    <tr><td><?=$r['id']?></td><td><?=$r['sale_date']?></td><td><?=number_format($r['total_amount'],2)?></td><td><?=htmlspecialchars($staff)?></td></tr>
    <?php endforeach; ?>
  </tbody>
</table>
<?php
$content = ob_get_clean();
require_once __DIR__ . '/../../includes/layout.php';
?>
