<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../includes/core.php';
if (!isLoggedIn() || getRole() !== 'manager') redirect(BASE_URL . '/login.php');

$error = '';
$success = '';
$full_name = '';
$email = '';
// On POST: validate and update
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $full_name = trim($_POST['full_name'] ?? '');
    $email = trim($_POST['email'] ?? '');
    if (!$full_name) {
        $error = 'Full Name is required.';
    } elseif (!$email) {
        $error = 'Email is required.';
    } elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $error = 'Invalid email format.';
    }
    if (!$error) {
        $stmt = mysqli_prepare($conn, "UPDATE users SET full_name = ?, email = ? WHERE id = ?");
        mysqli_stmt_bind_param($stmt, 'ssi', $full_name, $email, $_SESSION['user_id']);
        mysqli_stmt_execute($stmt) or die(mysqli_error($conn));
        mysqli_stmt_close($stmt);
        $success = 'Profile updated successfully.';
    }
} else {
    // On GET: fetch existing
    $stmt = mysqli_prepare($conn, "SELECT full_name, email FROM users WHERE id = ?");
    mysqli_stmt_bind_param($stmt, 'i', $_SESSION['user_id']);
    mysqli_stmt_execute($stmt);
    mysqli_stmt_bind_result($stmt, $db_name, $db_email);
    mysqli_stmt_fetch($stmt);
    mysqli_stmt_close($stmt);
    $full_name = $db_name;
    $email = $db_email;
}
ob_start();
?>
<h1 class="h2 mb-4">Edit Profile</h1>
<?php if ($error): ?>
  <div class="alert alert-danger"><?= htmlspecialchars($error) ?></div>
<?php elseif ($success): ?>
  <div class="alert alert-success"><?= htmlspecialchars($success) ?></div>
<?php endif; ?>
<form method="POST" class="mb-4">
  <div class="mb-3">
    <label class="form-label">Username</label>
    <input type="text" class="form-control" value="<?= htmlspecialchars(
        $_SESSION['username']
    ) ?>" readonly>
  </div>
  <div class="mb-3">
    <label class="form-label">Full Name</label>
    <input type="text" name="full_name" class="form-control" value="<?= htmlspecialchars($full_name) ?>" required>
  </div>
  <div class="mb-3">
    <label class="form-label">Email</label>
    <input type="email" name="email" class="form-control" value="<?= htmlspecialchars($email) ?>" required>
  </div>
  <button type="submit" class="btn btn-primary">Save Changes</button>
</form>
<?php
$content = ob_get_clean();
require_once __DIR__ . '/../../includes/layout.php';
?>
