<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../includes/core.php';
if (!isLoggedIn() || getRole() !== 'manager') redirect(BASE_URL . '/login.php');
// Assigned counter
$res = mysqli_query($conn, "SELECT assigned_counter_id FROM users WHERE id={$_SESSION['user_id']}");
$counterID = intval(mysqli_fetch_assoc($res)['assigned_counter_id'] ?? 0);
// Filters
$from = $_GET['from'] ?? '';
$to = $_GET['to'] ?? '';
$where = ["sr.counter_id=$counterID"];
if ($from) $where[] = "sr.created_at >= '" . mysqli_real_escape_string($conn, $from . " 00:00:00") . "'";
if ($to)   $where[] = "sr.created_at <= '" . mysqli_real_escape_string($conn, $to . " 23:59:59") . "'";
$w = $where ? 'WHERE ' . implode(' AND ', $where) : '';
// Data query
$sql = "SELECT sr.id AS request_id,
               p.name AS product,
               sr.quantity,
               sr.created_at AS request_date,
               sr.status AS request_status,
               d.dispatched_at,
               u1.username AS dispatched_by,
               d.received_at,
               u2.username AS received_by,
               COALESCE(sr.manager_remarks,'') AS manager_remarks
        FROM stock_requests sr
        LEFT JOIN products p ON sr.product_id=p.id
        LEFT JOIN dispatches d ON d.stock_request_id=sr.id
        LEFT JOIN users u1 ON d.dispatched_by=u1.id
        LEFT JOIN users u2 ON d.received_by=u2.id
        $w
        ORDER BY sr.created_at DESC";
$res = mysqli_query($conn, $sql) or die(mysqli_error($conn));
$data = mysqli_fetch_all($res, MYSQLI_ASSOC);
// Export CSV
if (isset($_GET['export']) && $_GET['export']==='csv') {
    header('Content-Type: text/csv');
    header('Content-Disposition: attachment; filename="request_dispatch_logs.csv"');
    $out = fopen('php://output','w');
    if (!empty($data)) fputcsv($out, array_keys($data[0]));
    foreach ($data as $row) fputcsv($out, $row);
    exit;
}
ob_start();
?>
<h1 class="h2 mb-4">Request & Dispatch Logs</h1>
<form method="GET" class="row g-3 mb-4">
  <div class="col-md-3"><input type="date" name="from" value="<?=htmlspecialchars($from)?>" class="form-control"></div>
  <div class="col-md-3"><input type="date" name="to"   value="<?=htmlspecialchars($to)?>"   class="form-control"></div>
  <div class="col-md-6 text-end">
    <button class="btn btn-primary">Filter</nutton>
    <a href="?<?=htmlspecialchars(http_build_query(['from'=>$from,'to'=>$to]))?>&export=csv" class="btn btn-secondary">Export CSV</a>
  </div>
</form>
<table class="table table-striped">
  <thead>
    <tr>
      <th>Req ID</th><th>Product</th><th>Qty</th><th>Req Date</th><th>Status</th><th>Disp At</th><th>Disp By</th><th>Rec At</th><th>Rec By</th><th>Mgr Remarks</th>
    </tr>
  </thead>
  <tbody>
    <?php foreach ($data as $r): ?>
    <tr>
      <td><?= $r['request_id'] ?></td>
      <td><?= htmlspecialchars($r['product']) ?></td>
      <td><?= intval($r['quantity']) ?></td>
      <td><?= $r['request_date'] ?></td>
      <td><?= ucfirst($r['request_status']) ?></td>
      <td><?= $r['dispatched_at'] ?? '-' ?></td>
      <td><?= htmlspecialchars($r['dispatched_by'] ?? '-') ?></td>
      <td><?= $r['received_at'] ?? '-' ?></td>
      <td><?= htmlspecialchars($r['received_by'] ?? '-') ?></td>
      <td><?= htmlspecialchars($r['manager_remarks']) ?></td>
    </tr>
    <?php endforeach; ?>
  </tbody>
</table>
<?php
$content = ob_get_clean();
require_once __DIR__ . '/../../includes/layout.php';
?>
