<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../includes/core.php';
if (!isLoggedIn() || getRole() !== 'manager') redirect(BASE_URL . '/login.php');
// Assigned counter
$res = mysqli_query($conn, "SELECT assigned_counter_id FROM users WHERE id={$_SESSION['user_id']}");
$counterID = intval(mysqli_fetch_assoc($res)['assigned_counter_id'] ?? 0);
// Fetch all requests
$sql = "SELECT sr.id, p.name AS product, sr.quantity, IFNULL(sr.remarks,'') AS remarks, sr.status
        FROM stock_requests sr
        JOIN products p ON sr.product_id=p.id
        WHERE sr.counter_id=$counterID
        ORDER BY sr.id DESC";
$reqs = mysqli_query($conn, $sql) or die(mysqli_error($conn));

ob_start();
?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <h1 class="h2">All Stock Requests</h1>
</div>
<table class="table table-striped">
  <thead><tr><th>ID</th><th>Product</th><th>Qty</th><th>Remarks</th><th>Status</th></tr></thead>
  <tbody>
    <?php while($r = mysqli_fetch_assoc($reqs)): ?>
    <tr>
      <td><?= $r['id'] ?></td>
      <td><?= htmlspecialchars($r['product']) ?></td>
      <td><?= $r['quantity'] ?></td>
      <td><?= htmlspecialchars($r['remarks']) ?></td>
      <td><?= ucfirst($r['status']) ?></td>
    </tr>
    <?php endwhile; ?>
  </tbody>
</table>
<?php
$content = ob_get_clean();
require_once __DIR__ . '/../../includes/layout.php';
?>
