<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../includes/core.php';
if (!isLoggedIn() || getRole() !== 'manager') redirect(BASE_URL . '/login.php');
// Ensure manager columns exist
$cols = [
    'manager_id' => 'INT UNSIGNED',
    'manager_action_at' => 'DATETIME',
    'manager_remarks' => 'TEXT',
];
foreach ($cols as $col => $def) {
    $chk = mysqli_query($conn, "SHOW COLUMNS FROM `stock_requests` LIKE '$col'");
    if (mysqli_num_rows($chk) === 0) {
        mysqli_query($conn, "ALTER TABLE `stock_requests` ADD COLUMN `$col` $def") or die(mysqli_error($conn));
    }
}
// Handle approve/reject
if (isset($_GET['action'], $_GET['id'])) {
    $id = intval($_GET['id']);
    $act = $_GET['action'] === 'approve' ? 'approved' : 'rejected';
    $remarks = mysqli_real_escape_string($conn, $_GET['remarks'] ?? '');
    mysqli_query($conn, "UPDATE stock_requests SET status='$act', manager_id={$_SESSION['user_id']}, manager_action_at=NOW(), manager_remarks='$remarks' WHERE id=$id") or die(mysqli_error($conn));
    redirect(BASE_URL . '/panels/manager/stock_requests_approval.php');
}
// Fetch pending/processed requests for assigned counter
$res = mysqli_query($conn, "SELECT u.assigned_counter_id FROM users u WHERE u.id={$_SESSION['user_id']}");
$counterID = intval(mysqli_fetch_assoc($res)['assigned_counter_id'] ?? 0);
$sql = "SELECT sr.id, p.name AS product, sr.quantity, sr.remarks, sr.status, sr.manager_remarks, sr.manager_action_at
        FROM stock_requests sr
        JOIN products p ON sr.product_id=p.id
        WHERE sr.counter_id=$counterID
        ORDER BY sr.id DESC";
$reqs = mysqli_query($conn, $sql) or die(mysqli_error($conn));
ob_start();
?>
<h1 class="h2 mb-4">Approve / Reject Stock Requests</h1>
<table class="table table-striped">
  <thead><tr><th>ID</th><th>Product</th><th>Qty</th><th>Remarks</th><th>Status</th><th>Action</th></tr></thead>
  <tbody>
  <?php while($r = mysqli_fetch_assoc($reqs)): ?>
    <tr>
      <td><?= $r['id'] ?></td>
      <td><?= htmlspecialchars($r['product']) ?></td>
      <td><?= $r['quantity'] ?></td>
      <td><?= htmlspecialchars($r['remarks']) ?></td>
      <td><?= ucfirst($r['status']) ?></td>
      <td>
        <?php if ($r['status'] === 'pending'): ?>
        <a href="?action=approve&id=<?= $r['id'] ?>" class="btn btn-sm btn-success">Approve</a>
        <a href="?action=reject&id=<?= $r['id'] ?>" class="btn btn-sm btn-danger">Reject</a>
        <?php else: ?>
        <small><?= ucfirst($r['status']) ?></small>
        <?php endif; ?>
      </td>
    </tr>
  <?php endwhile; ?>
  </tbody>
</table>
<?php
$content = ob_get_clean();
require_once __DIR__ . '/../../includes/layout.php';
?>
