<?php
header('Content-Type: application/json');
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../includes/core.php';
if (!isLoggedIn() || getRole() !== 'sales') {
    echo json_encode(['success'=>false,'message'=>'Unauthorized']);
    exit;
}
$data = json_decode(file_get_contents('php://input'), true);
$saleId = intval($data['id'] ?? 0);
if ($saleId <= 0) {
    echo json_encode(['success'=>false,'message'=>'Invalid sale ID']);
    exit;
}
$user_id = $_SESSION['user_id'];
// Assigned counter
$res = mysqli_query($conn, "SELECT assigned_counter_id FROM users WHERE id=$user_id");
$counterID = intval(mysqli_fetch_assoc($res)['assigned_counter_id'] ?? 0);
// Verify sale
$chk = mysqli_query($conn, "SELECT id FROM sales WHERE id=$saleId AND counter_id=$counterID");
if (mysqli_num_rows($chk) === 0) {
    echo json_encode(['success'=>false,'message'=>'Sale not found']);
    exit;
}
// Restock items
$itemsRes = mysqli_query($conn, "SELECT product_id, quantity FROM sales_items WHERE sale_id=$saleId");
mysqli_begin_transaction($conn);
try {
    while ($row = mysqli_fetch_assoc($itemsRes)) {
        $pid = intval($row['product_id']);
        $qty = intval($row['quantity']);
        mysqli_query($conn, "UPDATE counter_stock SET quantity = quantity + $qty WHERE counter_id=$counterID AND product_id=$pid");
    }
    // Delete sale items and sale
    mysqli_query($conn, "DELETE FROM sales_items WHERE sale_id=$saleId");
    mysqli_query($conn, "DELETE FROM sales WHERE id=$saleId");
    mysqli_commit($conn);
    echo json_encode(['success'=>true]);
} catch (Exception $e) {
    mysqli_rollback($conn);
    echo json_encode(['success'=>false,'message'=>$e->getMessage()]);
}
