<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../includes/core.php';
if (!isLoggedIn() || getRole() !== 'sales') redirect(BASE_URL . '/login.php');

// Assigned counter
$res = mysqli_query($conn, "SELECT assigned_counter_id FROM users WHERE id={$_SESSION['user_id']}");
$counterID = intval(mysqli_fetch_assoc($res)['assigned_counter_id'] ?? 0);

// Fetch all sales orders
$sql = "SELECT id, sale_date, total_amount FROM sales WHERE counter_id=$counterID ORDER BY sale_date DESC";
$q = mysqli_query($conn, $sql);
$sales = mysqli_fetch_all($q, MYSQLI_ASSOC);

ob_start();
?>
<h1 class="h2 mb-4">Cancel / Refund</h1>
<div class="mb-3">
  <a href="<?= BASE_URL ?>/panels/sales/pos.php?type=dinein" class="btn btn-primary btn-sm">Go to POS</a>
</div>
<div class="mb-3">
  <input type="text" id="cancelSearch" class="form-control w-25" placeholder="Search orders...">
</div>
<table class="table table-striped" id="cancelTable">
  <thead>
    <tr>
      <th>Sale ID</th>
      <th>Date</th>
      <th>Total</th>
      <th>Action</th>
    </tr>
  </thead>
  <tbody>
    <?php foreach ($sales as $s): ?>
    <tr data-id="<?= $s['id'] ?>">
      <td><?= $s['id'] ?></td>
      <td><?= htmlspecialchars($s['sale_date']) ?></td>
      <td>₹<?= number_format($s['total_amount'],2) ?></td>
      <td><button class="btn btn-sm btn-danger cancel-btn">Cancel</button></td>
    </tr>
    <?php endforeach; ?>
  </tbody>
</table>
<script>
// Search filter
document.getElementById('cancelSearch').addEventListener('input', function(e) {
  const term = e.target.value.toLowerCase();
  document.querySelectorAll('#cancelTable tbody tr').forEach(tr => {
    tr.style.display = tr.textContent.toLowerCase().includes(term) ? '' : 'none';
  });
});
// Cancel action
document.querySelectorAll('.cancel-btn').forEach(btn => {
  btn.onclick = async function() {
    if (!confirm('Are you sure you want to cancel this order?')) return;
    const row = this.closest('tr');
    const id = row.dataset.id;
    try {
      const res = await fetch('cancel_api.php', {
        method: 'POST',
        headers: {'Content-Type':'application/json'},
        body: JSON.stringify({id})
      });
      const d = await res.json();
      if (d.success) {
        row.remove();
      } else {
        alert(d.message);
      }
    } catch(err) { alert('Error: '+err.message); }
  };
});
</script>
<?php
$content = ob_get_clean();
require_once __DIR__ . '/../../includes/layout.php';
?>
