<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../includes/core.php';
if (!isLoggedIn() || getRole() !== 'sales') redirect(BASE_URL . '/login.php');
$res = mysqli_query($conn, "SELECT assigned_counter_id FROM users WHERE id={$_SESSION['user_id']}");
$counterID = intval(mysqli_fetch_assoc($res)['assigned_counter_id'] ?? 0);
// Date range
$start = $_GET['start'] ?? date('Y-m-d');
$end = $_GET['end'] ?? date('Y-m-d');
$sql = "SELECT DATE(sale_date) AS date, COUNT(*) AS orders, SUM(total_amount) AS total
        FROM sales WHERE counter_id=$counterID
          AND sale_date BETWEEN '$start 00:00:00' AND '$end 23:59:59'
        GROUP BY DATE(sale_date) ORDER BY date DESC";
$q = mysqli_query($conn, $sql);
$data = mysqli_fetch_all($q, MYSQLI_ASSOC);
ob_start();
?>
<h1 class="h2 mb-4">Daily Sales Report</h1>
<form method="get" class="row g-3 mb-3">
  <div class="col-auto">
    <input type="date" name="start" value="<?= htmlspecialchars($start) ?>" class="form-control">
  </div>
  <div class="col-auto">
    <input type="date" name="end" value="<?= htmlspecialchars($end) ?>" class="form-control">
  </div>
  <div class="col-auto">
    <button type="submit" class="btn btn-primary">Filter</button>
  </div>
</form>
<table class="table table-striped">
  <thead><tr><th>Date</th><th>Orders</th><th>Total (₹)</th></tr></thead>
  <tbody>
    <?php foreach($data as $row): ?>
    <tr>
      <td><?= htmlspecialchars($row['date']) ?></td>
      <td><?= intval($row['orders']) ?></td>
      <td>₹<?= number_format($row['total'],2) ?></td>
    </tr>
    <?php endforeach; ?>
  </tbody>
</table>
<?php
$content = ob_get_clean();
require_once __DIR__ . '/../../includes/layout.php';
?>
