<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../includes/core.php';
if (!isLoggedIn() || getRole() !== 'sales') redirect(BASE_URL . '/login.php');

// Assigned counter
$res = mysqli_query($conn, "SELECT assigned_counter_id FROM users WHERE id={$_SESSION['user_id']}");
$counterID = intval(mysqli_fetch_assoc($res)['assigned_counter_id'] ?? 0);

$today = date('Y-m-d');

// Today's Sales Summary
$salesRes = mysqli_query($conn, "SELECT IFNULL(SUM(total_amount),0) AS total FROM sales WHERE counter_id=$counterID AND DATE(sale_date)='$today'");
$salesTotal = mysqli_fetch_assoc($salesRes)['total'];

// Current Counter Stock
$stockRes = mysqli_query($conn, "SELECT IFNULL(SUM(quantity),0) AS qty FROM counter_stock WHERE counter_id=$counterID");
$stockTotal = mysqli_fetch_assoc($stockRes)['qty'];

// Pending Stock Requests
$pendingRes = mysqli_query($conn, "SELECT COUNT(*) AS cnt FROM stock_requests WHERE counter_id=$counterID AND status='pending'");
$pendingCount = mysqli_fetch_assoc($pendingRes)['cnt'];

// Top-Selling Items (using stock_movements)
$topItemsRes = mysqli_query($conn, "SELECT p.name, SUM(sm.quantity) AS sold_qty
    FROM stock_movements sm
    JOIN products p ON sm.product_id=p.id
    WHERE sm.counter_id=$counterID AND sm.movement_type='out' AND DATE(sm.created_at)='$today'
    GROUP BY sm.product_id ORDER BY sold_qty DESC LIMIT 5");
$topItems = [];
while ($row = mysqli_fetch_assoc($topItemsRes)) {
    $topItems[] = $row;
}

// Sales Trend Data (last 7 days)
$trendRes = mysqli_query($conn, "SELECT DATE(sale_date) AS date, SUM(total_amount) AS total
    FROM sales WHERE counter_id=$counterID AND sale_date >= DATE_SUB(NOW(), INTERVAL 6 DAY)
    GROUP BY DATE(sale_date) ORDER BY DATE(sale_date)");
$trendData = [];
while ($row = mysqli_fetch_assoc($trendRes)) {
    $trendData[$row['date']] = $row['total'];
}

// Day Opening Stock
$openRes = mysqli_query($conn, "SELECT IFNULL(SUM(quantity),0) AS qty FROM day_opening_stock WHERE counter_id=$counterID AND DATE(opened_at)='$today'");
$openTotal = mysqli_fetch_assoc($openRes)['qty'];

// Day Closing Stock
$closeRes = mysqli_query($conn, "SELECT IFNULL(SUM(quantity),0) AS qty FROM day_closing_stock WHERE counter_id=$counterID AND DATE(closed_at)='$today'");
$closeTotal = mysqli_fetch_assoc($closeRes)['qty'];

// Render
ob_start();
?>
<h1 class="h2 mb-4 d-flex justify-content-between align-items-center">
  Sales Dashboard
  <a href="<?= BASE_URL ?>/panels/sales/pos.php" class="btn btn-sm btn-primary">Launch POS</a>
</h1>
<div class="row">
  <div class="col-md-4 mb-4">
    <div class="card p-3">
      <h5>Today's Sales Summary</h5>
      <h3>₹<?= number_format($salesTotal,2) ?></h3>
    </div>
  </div>
  <div class="col-md-4 mb-4">
    <div class="card p-3">
      <h5>Current Counter Stock</h5>
      <h3><?= $stockTotal ?></h3>
    </div>
  </div>
  <div class="col-md-4 mb-4">
    <div class="card p-3">
      <h5>Pending Stock Requests</h5>
      <h3><?= $pendingCount ?></h3>
    </div>
  </div>
  <div class="col-md-4 mb-4">
    <div class="card p-3">
      <h5>Day Opening Stock</h5>
      <h3><?= $openTotal ?></h3>
    </div>
  </div>
  <div class="col-md-4 mb-4">
    <div class="card p-3">
      <h5>Day Closing Stock</h5>
      <h3><?= $closeTotal ?></h3>
    </div>
  </div>
  <div class="col-md-4 mb-4">
    <div class="card">
      <div class="card-body">
        <h5>Top-Selling Items</h5>
        <ul class="list-group list-group-flush">
          <?php if ($topItems): foreach ($topItems as $item): ?>
            <li class="list-group-item d-flex justify-content-between">
              <?= htmlspecialchars($item['name']) ?>
              <span><?= intval($item['sold_qty']) ?></span>
            </li>
          <?php endforeach; else: ?>
            <li class="list-group-item text-muted">No sales today</li>
          <?php endif; ?>
        </ul>
      </div>
    </div>
  </div>

  <div class="col-12 mb-4">
    <canvas id="salesTrendChart" height="100"></canvas>
  </div>

</div>

<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
const labels = <?= json_encode(array_keys($trendData)) ?>;
const data = <?= json_encode(array_values($trendData)) ?>;
new Chart(document.getElementById('salesTrendChart'), {
  type: 'line',
  data: { labels, datasets: [{ label: 'Sales', data, fill: false, borderColor: 'rgb(75,192,192)' }] },
});
</script>
<?php
$content = ob_get_clean();
require_once __DIR__ . '/../../includes/layout.php';
?>
