<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../includes/core.php';
if (!isLoggedIn() || getRole() !== 'sales') redirect(BASE_URL . '/login.php');
$user_id = $_SESSION['user_id'];
// Assigned counter
$res = mysqli_query($conn, "SELECT assigned_counter_id FROM users WHERE id=$user_id");
$counterID = intval(mysqli_fetch_assoc($res)['assigned_counter_id'] ?? 0);
$error = '';
// Check if day opened
$oq = mysqli_query($conn, "SELECT id FROM day_openings WHERE counter_id=$counterID AND DATE(opened_at)=CURDATE() LIMIT 1");
$opened = mysqli_fetch_assoc($oq);
// Check if day closed
$cq = mysqli_query($conn, "SELECT id, closed_at FROM day_closing_stock WHERE counter_id=$counterID AND DATE(closed_at)=CURDATE() LIMIT 1");
$closedRow = mysqli_fetch_assoc($cq);
$closed = (bool)$closedRow;

if ($_SERVER['REQUEST_METHOD'] === 'POST' && !$closed && $opened) {
    $qtys = $_POST['qty'] ?? [];
    mysqli_begin_transaction($conn);
    try {
        // record closing stock
        foreach ($qtys as $pid => $q) {
            $pidI = intval($pid);
            $qI = intval($q);
            mysqli_query($conn, "INSERT INTO day_closing_stock (counter_id, product_id, quantity, closed_at) VALUES ($counterID, $pidI, $qI, NOW())") or throw new Exception(mysqli_error($conn));
        }
        mysqli_commit($conn);
        redirect(BASE_URL . '/panels/sales/day_closing.php');
    } catch (Exception $e) {
        mysqli_rollback($conn);
        $error = $e->getMessage();
    }
}
// Fetch current stock for form defaults
$stocksRes = mysqli_query($conn, "SELECT p.id AS product_id, p.name, IFNULL(cs.quantity,0) AS quantity FROM products p LEFT JOIN counter_stock cs ON p.id=cs.product_id AND cs.counter_id=$counterID");
$stocks = mysqli_fetch_all($stocksRes, MYSQLI_ASSOC);

ob_start();
?>
<h1 class="h2 mb-4">Day Closing Stock</h1>
<?php if (!$opened): ?>
  <div class="alert alert-warning">Please perform Day Opening first.</div>
<?php elseif ($closed): ?>
  <div class="alert alert-info">Already closed today at <?= htmlspecialchars($closedRow['closed_at']) ?></div>
<?php else: ?>
  <?php if ($error): ?><div class="alert alert-danger"><?= htmlspecialchars($error) ?></div><?php endif; ?>
  <form method="POST">
    <table class="table table-sm">
      <thead><tr><th>Product</th><th>Closing Quantity</th></tr></thead>
      <tbody>
      <?php foreach ($stocks as $s): ?>
      <tr>
        <td><?= htmlspecialchars($s['name']) ?></td>
        <td><input type="number" name="qty[<?= $s['product_id'] ?>]" class="form-control form-control-sm" value="<?= $s['quantity'] ?>" min="0"></td>
      </tr>
      <?php endforeach; ?>
      </tbody>
    </table>
    <button class="btn btn-success">Save Closing Stock</button>
  </form>
<?php endif; ?>
<?php
$content = ob_get_clean();
require_once __DIR__ . '/../../includes/layout.php';
