<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../includes/core.php';
if (!isLoggedIn() || getRole() !== 'sales') exit;

// Assigned counter
$res = mysqli_query($conn, "SELECT assigned_counter_id FROM users WHERE id={$_SESSION['user_id']}");
$counterID = intval(mysqli_fetch_assoc($res)['assigned_counter_id'] ?? 0);

// Determine invoice action: list or detail
$saleId = intval($_GET['id'] ?? 0);
if ($saleId <= 0) {
    // Invoice listing
    $sqlList = "SELECT id, sale_date, total_amount FROM sales WHERE counter_id=$counterID ORDER BY sale_date DESC";
    $qList = mysqli_query($conn, $sqlList);
    $invoices = mysqli_fetch_all($qList, MYSQLI_ASSOC);
    ob_start();
    ?>
    <h1 class="h2 mb-4">Invoices</h1>
    <div class="mb-3">
      <input type="text" id="invoiceSearch" class="form-control w-25" placeholder="Search invoices...">
    </div>
    <table class="table table-striped" id="invoiceTable">
      <thead>
        <tr><th>Invoice #</th><th>Date</th><th>Total</th><th>Print</th></tr>
      </thead>
      <tbody>
        <?php foreach ($invoices as $inv): ?>
        <tr data-id="<?= $inv['id'] ?>">
          <td><?= $inv['id'] ?></td>
          <td><?= htmlspecialchars($inv['sale_date']) ?></td>
          <td>₹<?= number_format($inv['total_amount'],2) ?></td>
          <td><a href="?id=<?= $inv['id'] ?>" target="_blank" class="btn btn-sm btn-info">Print</a></td>
        </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
    <script>
    document.getElementById('invoiceSearch').addEventListener('input', function(e) {
      const term = e.target.value.toLowerCase();
      document.querySelectorAll('#invoiceTable tbody tr').forEach(tr => {
        tr.style.display = tr.textContent.toLowerCase().includes(term) ? '' : 'none';
      });
    });
    </script>
    <?php
    $content = ob_get_clean();
    require_once __DIR__ . '/../../includes/layout.php';
    exit;
}

// Fetch sale header
$sq = "SELECT s.id, s.sale_date, s.total_amount, u.full_name, c.name AS counter_name
        FROM sales s
        LEFT JOIN users u ON s.created_by=u.id
        LEFT JOIN counters c ON s.counter_id=c.id
        WHERE s.id=$saleId AND s.counter_id=$counterID";
$hdr = mysqli_query($conn, $sq);
$sale = mysqli_fetch_assoc($hdr);
if (!$sale) {
    echo "<div class='alert alert-danger'>Invoice not found.</div>";
    exit;
}

// Fetch items
$is = "SELECT si.quantity, si.price, si.total, p.name, cat.name AS category, sz.name AS size
         FROM sales_items si
         JOIN products p ON si.product_id=p.id
         LEFT JOIN categories cat ON p.category_id=cat.id
         LEFT JOIN sizes sz ON p.size_id=sz.id
         WHERE si.sale_id=$saleId";
$itQ = mysqli_query($conn, $is);
$items = mysqli_fetch_all($itQ, MYSQLI_ASSOC);

ob_start();
?>
<div class="invoice">
  <h2>Invoice #<?= $sale['id'] ?></h2>
  <p><strong>Date:</strong> <?= htmlspecialchars($sale['sale_date']) ?></p>
  <p><strong>Cashier:</strong> <?= htmlspecialchars($sale['full_name']) ?></p>
  <p><strong>Counter:</strong> <?= htmlspecialchars($sale['counter_name']) ?></p>
  <table class="table table-bordered">
    <thead><tr><th>Product</th><th>Category</th><th>Size</th><th>Qty</th><th>Price</th><th>Total</th></tr></thead>
    <tbody>
    <?php foreach ($items as $it): ?>
    <tr>
      <td><?= htmlspecialchars($it['name']) ?></td>
      <td><?= htmlspecialchars($it['category']) ?></td>
      <td><?= htmlspecialchars($it['size']) ?></td>
      <td><?= intval($it['quantity']) ?></td>
      <td>₹<?= number_format($it['price'],2) ?></td>
      <td>₹<?= number_format($it['total'],2) ?></td>
    </tr>
    <?php endforeach; ?>
    </tbody>
    <tfoot>
      <tr>
        <th colspan="5" class="text-end">Grand Total</th>
        <th>₹<?= number_format($sale['total_amount'],2) ?></th>
      </tr>
    </tfoot>
  </table>
  <button class="btn btn-primary" onclick="window.print()">Print Invoice</button>
</div>
<style>
.invoice { max-width:800px; margin:2rem auto; }
.invoice h2 { margin-bottom:1rem; }
@media print { .btn { display:none; } }
</style>
<?php
$content = ob_get_clean();
require_once __DIR__ . '/../../includes/layout.php';
?>
