<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../includes/core.php';
if (!isLoggedIn() || getRole() !== 'sales') redirect(BASE_URL . '/login.php');
// Assigned counter
$res = mysqli_query($conn, "SELECT assigned_counter_id FROM users WHERE id={$_SESSION['user_id']}");
$counterID = intval(mysqli_fetch_assoc($res)['assigned_counter_id'] ?? 0);
// Threshold
$threshold = intval($_GET['threshold'] ?? 10);
// Fetch low-stock items
$sql = "SELECT p.id, p.name, c.name AS category, s.name AS size, cs.quantity AS stock
        FROM counter_stock cs
        JOIN products p ON cs.product_id=p.id
        LEFT JOIN categories c ON p.category_id=c.id
        LEFT JOIN sizes s ON p.size_id=s.id
        WHERE cs.counter_id=$counterID AND cs.quantity <= $threshold
        ORDER BY cs.quantity ASC";
$q = mysqli_query($conn, $sql);
$items = mysqli_fetch_all($q, MYSQLI_ASSOC);
ob_start();
?>
<h1 class="h2 mb-4">Low Stock Report</h1>
<form method="get" class="row g-3 mb-3">
  <div class="col-auto">
    <label class="form-label">Threshold</label>
    <input type="number" name="threshold" min="0" value="<?= htmlspecialchars($threshold) ?>" class="form-control">
  </div>
  <div class="col-auto">
    <label class="form-label invisible">filter</label>
    <button type="submit" class="btn btn-primary d-block">Filter</button>
  </div>
</form>
<table class="table table-striped" id="lowStockTable">
  <thead>
    <tr><th>Product</th><th>Category</th><th>Size</th><th>Stock</th></tr>
  </thead>
  <tbody>
    <?php if ($items): foreach ($items as $it): ?>
    <tr>
      <td><?= htmlspecialchars($it['name']) ?></td>
      <td><?= htmlspecialchars($it['category']) ?></td>
      <td><?= htmlspecialchars($it['size']) ?></td>
      <td><?= intval($it['stock']) ?></td>
    </tr>
    <?php endforeach; else: ?>
    <tr><td colspan="4" class="text-center">All stock levels above threshold.</td></tr>
    <?php endif; ?>
  </tbody>
</table>
<script>
// optional client-side filter
</script>
<?php
$content = ob_get_clean();
require_once __DIR__ . '/../../includes/layout.php';
?>
