<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../includes/core.php';
if (!isLoggedIn() || getRole() !== 'sales') redirect(BASE_URL . '/login.php');

// Order type
$type = $_GET['type'] ?? 'dinein';
// Assigned counter
$res = mysqli_query($conn, "SELECT assigned_counter_id FROM users WHERE id={$_SESSION['user_id']}");
$counterID = intval(mysqli_fetch_assoc($res)['assigned_counter_id'] ?? 0);
// Fetch all available products for this counter
$prodRes = mysqli_query($conn, "SELECT p.id, p.name, COALESCE(s.name,'') AS size, p.price, IFNULL(cs.quantity,0) AS stock, '' AS image
    FROM products p
    LEFT JOIN sizes s ON p.size_id = s.id
    LEFT JOIN counter_stock cs ON p.id=cs.product_id AND cs.counter_id=$counterID
    WHERE IFNULL(cs.quantity,0) > 0
    ORDER BY p.name");
$products = mysqli_fetch_all($prodRes, MYSQLI_ASSOC);

// Fetch floors list for dine-in table selection
$floorsRes = mysqli_query($conn, "SELECT id, name FROM floors ORDER BY name");
$floors = mysqli_fetch_all($floorsRes, MYSQLI_ASSOC);

ob_start();
?>
<style>
  .product-card { width: 120px; cursor: pointer; }
  .product-img { height: 80px; object-fit: contain; }
  #cartPanel { height: calc(100vh - 120px); overflow-y:auto; }
</style>
<h1 class="h2 mb-4">POS System</h1>
<div class="row mb-3 align-items-center">
  <div class="col-auto d-flex align-items-center">
    <select id="orderType" class="form-select me-2 w-auto">
      <option value="dinein">Dine-In</option>
      <option value="takeaway">Takeaway</option>
      <option value="delivery">Delivery</option>
    </select>
    <?php if ($type==='dinein'): ?>
      <select id="floorSelectInline" class="form-select me-2 w-auto">
        <option value="">Select Floor</option>
        <?php foreach($floors as $f): ?>
          <option value="<?= $f['id'] ?>"><?= htmlspecialchars($f['name']) ?></option>
        <?php endforeach; ?>
      </select>
      <select id="tableSelectInline" class="form-select me-2 w-auto" style="display:none;">
        <option value="">Select Table</option>
      </select>
      <span id="selectedTableDisplay" class="ms-2"></span>
    <?php endif; ?>
    <input type="text" id="searchProducts" class="form-control ms-3" placeholder="Search products...">
    <button class="btn btn-secondary ms-3" onclick="window.location='<?= BASE_URL ?>/panels/sales/current_stock.php'">Stock</button>
  </div>
</div>
<div class="row">
  <div class="col-md-8">
    <div class="row g-2" id="productGrid">
      <?php foreach($products as $p): ?>
      <div class="col-auto">
        <div class="card product-card" data-id="<?= $p['id'] ?>" onclick="addToCart(<?= $p['id'] ?>,'<?= addslashes($p['name']) ?>',<?= $p['price'] ?>)">
          <img src="<?= BASE_URL . ($p['image']?:'/assets/img/default.png') ?>" class="card-img-top product-img" alt="<?= htmlspecialchars($p['name']) ?>">
          <div class="card-body p-2">
            <h6 class="card-title mb-1"><?= htmlspecialchars($p['name']) ?></h6>
            <p class="mb-1"><small><?= $p['size'] ?></small></p>
            <p class="mb-1"><strong>₹<?= number_format($p['price'],2) ?></strong></p>
            <p class="text-muted"><small>Stock: <?= $p['stock'] ?></small></p>
          </div>
        </div>
      </div>
      <?php endforeach; ?>
    </div>
  </div>
  <div class="col-md-4">
    <div class="card" id="cartPanel">
      <div class="card-body d-flex flex-column">
        <h5>Cart</h5>
        <div class="flex-grow-1 mb-2" style="overflow-y:auto;">
          <table class="table table-sm" id="cartTable">
            <thead><tr><th>Item</th><th>Qty</th><th>Price</th><th></th></tr></thead>
            <tbody></tbody>
          </table>
        </div>
        <div><strong>Total: ₹<span id="cartTotal">0.00</span></strong></div>
        <div class="mb-2">
          <label for="paymentModeSelect" class="form-label">Payment Mode:</label>
          <select id="paymentModeSelect" class="form-select">
            <option value="cash">Cash</option>
            <option value="card">Card</option>
            <option value="upi">UPI</option>
          </select>
        </div>
        <?php if ($type==='dinein'): ?>
        <button class="btn btn-primary mb-2 w-100" onclick="confirmOrder()">Confirm Order</button>
        <?php endif; ?>
        <button class="btn btn-success mt-2 w-100" onclick="checkout()">Checkout</button>
      </div>
    </div>
  </div>
</div>
<script>
let cart = {};
let selectedTableId = 0; 

// Load existing order items for a table
async function loadTableOrder(){
  if (!selectedTableId) return;
  const res = await fetch(`table_order_api.php?table=${selectedTableId}`);
  const result = await res.json();
  cart = {};
  result.items.forEach(i=>{ cart[i.id] = { name: i.name, price: parseFloat(i.price), qty: parseInt(i.qty) }; });
  renderCart();
}

// Save current cart as table order
function confirmOrder(){
  if (!selectedTableId){ alert('Please select a table first'); return; }
  if (Object.keys(cart).length===0){ alert('Cart is empty'); return; }
  fetch('table_order_api.php', {
    method:'POST', headers:{'Content-Type':'application/json'},
    body: JSON.stringify({ table_id:selectedTableId, cart: Object.entries(cart).map(([id,it])=>({ id, qty:it.qty, price:it.price })) })
  })
  .then(r=>r.json()).then(d=>{ if(d.success) alert('Order saved'); else alert(d.message); }).catch(e=>alert('Error: '+e.message));
}

function addToCart(id,name,price){
  if (document.getElementById('orderType').value==='dinein' && selectedTableId===0){ alert('Please select a table first'); return; }
  if(!cart[id]) cart[id]={name,price,qty:0};
  cart[id].qty++;
  renderCart();
}
function removeFromCart(id){ delete cart[id]; renderCart(); }
function renderCart(){
  const tbody=document.querySelector('#cartTable tbody'); tbody.innerHTML=''; let total=0;
  for(let id in cart){const it=cart[id];total+=it.price*it.qty;
    const tr=document.createElement('tr'); tr.innerHTML=`<td>${it.name}</td><td>${it.qty}</td><td>₹${it.price*it.qty}</td><td><button class="btn btn-sm btn-danger" onclick="removeFromCart(${id})">x</button></td>`;
    tbody.appendChild(tr);
  }
  document.getElementById('cartTotal').innerText=total.toFixed(2);
}
function checkout(){
  if(Object.keys(cart).length===0){
    alert('Cart is empty');
    return;
  }
  const payload = { type: document.getElementById('orderType').value, table_id: selectedTableId, cart: [], payment_mode: document.getElementById('paymentModeSelect').value };
  for(let id in cart){
    payload.cart.push({ id: id, price: cart[id].price, qty: cart[id].qty });
  }
  fetch('pos_api.php', {
    method: 'POST',
    headers: { 'Content-Type': 'application/json' },
    body: JSON.stringify(payload)
  })
  .then(res=>res.json())
  .then(data=>{
    if(data.success){
      window.location = 'invoice.php?id='+data.sale_id;
    } else {
      alert(data.message);
    }
  })
  .catch(err=>alert('Error: '+err.message));
}

// Show floor dropdown when Dine-In selected
const orderTypeSel = document.getElementById('orderType');
orderTypeSel.addEventListener('change', e => {
  const floorSel = document.getElementById('floorSelectInline');
  const tableSel = document.getElementById('tableSelectInline');
  if (e.target.value === 'dinein') {
    floorSel.style.display = '';
  } else {
    floorSel.style.display = 'none';
    tableSel.style.display = 'none';
    selectedTableId = 0;
    document.getElementById('selectedTableDisplay').innerText = '';
  }
});

// Load tables when floor changes
document.getElementById('floorSelectInline').addEventListener('change', async function() {
  const floorId = this.value;
  const tableSel = document.getElementById('tableSelectInline');
  if (!floorId) {
    tableSel.style.display = 'none';
    tableSel.innerHTML = '<option value="">Select Table</option>';
    return;
  }
  const res = await fetch(`table_api.php?floor=${floorId}`);
  const tables = await res.json();
  let opts = '<option value="">Select Table</option>';
  tables.forEach(t => {
    opts += `<option value="${t.id}">${t.table_number} (${t.status})</option>`;
  });
  tableSel.innerHTML = opts;
  tableSel.style.display = '';
});

// Handle table selection
document.getElementById('tableSelectInline').addEventListener('change', function() {
  selectedTableId = this.value;
  document.getElementById('selectedTableDisplay').innerText = this.options[this.selectedIndex].text;
  loadTableOrder();
});

// Search filter
document.getElementById('searchProducts').addEventListener('input', function(e){
  const term = e.target.value.toLowerCase();
  document.querySelectorAll('.product-card').forEach(card => {
    const txt = card.querySelector('.card-title').textContent.toLowerCase();
    card.style.display = txt.includes(term) ? 'block' : 'none';
  });
});
// Barcode scanning
document.getElementById('barcodeInput').addEventListener('keydown', function(e){
  if(e.key==='Enter'){
    const val = this.value.trim();
    if(val){
      const card = document.querySelector(`.product-card[data-id="${val}"]`);
      if(card) card.click();
      else alert('Product not found');
      this.value='';
    }
  }
});
</script>
<?php
$content=ob_get_clean();
require_once __DIR__.'/../../includes/layout.php';
?>
