<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../includes/core.php';
if (!isLoggedIn() || getRole() !== 'sales') redirect(BASE_URL . '/login.php');
$res = mysqli_query($conn, "SELECT assigned_counter_id FROM users WHERE id={$_SESSION['user_id']}");
$counterID = intval(mysqli_fetch_assoc($res)['assigned_counter_id'] ?? 0);
// Date range
$start = $_GET['start'] ?? date('Y-m-d');
$end = $_GET['end'] ?? date('Y-m-d');
// Fetch product-wise sales
$sql = "SELECT p.id, p.name, SUM(si.quantity) AS qty_sold, SUM(si.total) AS total_sales
        FROM sales_items si
        JOIN sales s ON si.sale_id=s.id
        JOIN products p ON si.product_id=p.id
        WHERE s.counter_id=$counterID
          AND s.sale_date BETWEEN '$start 00:00:00' AND '$end 23:59:59'
        GROUP BY p.id, p.name
        ORDER BY total_sales DESC";
$q = mysqli_query($conn, $sql);
$data = mysqli_fetch_all($q, MYSQLI_ASSOC);
ob_start();
?>
<h1 class="h2 mb-4">Product-wise Sales Report</h1>
<form method="get" class="row g-3 mb-3">
  <div class="col-auto"><input type="date" name="start" value="<?= htmlspecialchars($start) ?>" class="form-control"></div>
  <div class="col-auto"><input type="date" name="end" value="<?= htmlspecialchars($end) ?>" class="form-control"></div>
  <div class="col-auto"><button type="submit" class="btn btn-primary">Filter</button></div>
</form>
<table class="table table-striped">
  <thead><tr><th>Product</th><th>Quantity Sold</th><th>Total Sales (₹)</th></tr></thead>
  <tbody>
    <?php foreach($data as $row): ?>
    <tr>
      <td><?= htmlspecialchars($row['name']) ?></td>
      <td><?= intval($row['qty_sold']) ?></td>
      <td>₹<?= number_format($row['total_sales'],2) ?></td>
    </tr>
    <?php endforeach; ?>
  </tbody>
</table>
<?php
$content = ob_get_clean();
require_once __DIR__ . '/../../includes/layout.php';
?>
