<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../includes/core.php';
if (!isLoggedIn() || getRole() !== 'sales') redirect(BASE_URL . '/login.php');
// Assigned counter
$res = mysqli_query($conn, "SELECT assigned_counter_id FROM users WHERE id={$_SESSION['user_id']}");
$counterID = intval(mysqli_fetch_assoc($res)['assigned_counter_id'] ?? 0);
// Fetch sales history
$sql = "SELECT id, sale_date, total_amount FROM sales WHERE counter_id=$counterID ORDER BY sale_date DESC";
$q = mysqli_query($conn, $sql);
$sales = mysqli_fetch_all($q, MYSQLI_ASSOC);
ob_start();
?>
<h1 class="h2 mb-4">Sales History</h1>
<div class="mb-3">
  <a href="<?= BASE_URL ?>/panels/sales/pos.php?type=dinein" class="btn btn-primary btn-sm">Go to POS</a>
</div>
<div class="mb-3">
  <input type="text" id="salesSearch" class="form-control w-25" placeholder="Search sales...">
</div>
<table class="table table-striped" id="salesTable">
  <thead>
    <tr>
      <th>Sale ID</th>
      <th>Date</th>
      <th>Total</th>
      <th>Invoice</th>
    </tr>
  </thead>
  <tbody>
    <?php foreach ($sales as $s): ?>
    <tr>
      <td><?= $s['id'] ?></td>
      <td><?= htmlspecialchars($s['sale_date']) ?></td>
      <td>₹<?= number_format($s['total_amount'],2) ?></td>
      <td><a href="<?= BASE_URL ?>/panels/sales/invoice.php?id=<?= $s['id'] ?>" class="btn btn-sm btn-info">View</a></td>
    </tr>
    <?php endforeach; ?>
  </tbody>
</table>
<script>
// Search filter
document.getElementById('salesSearch').addEventListener('input', function(e) {
  const term = e.target.value.toLowerCase();
  document.querySelectorAll('#salesTable tbody tr').forEach(tr => {
    tr.style.display = tr.textContent.toLowerCase().includes(term) ? '' : 'none';
  });
});
</script>
<?php
$content = ob_get_clean();
require_once __DIR__ . '/../../includes/layout.php';
?>
