<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../includes/core.php';
if (!isLoggedIn() || getRole() !== 'sales') redirect(BASE_URL . '/login.php');

// Assigned counter
$res = mysqli_query($conn, "SELECT assigned_counter_id FROM users WHERE id={$_SESSION['user_id']}");
$counterID = intval(mysqli_fetch_assoc($res)['assigned_counter_id'] ?? 0);

// Fetch stock request history
$sql = "SELECT r.id, p.name AS product, c.name AS category, COALESCE(s.name, '') AS size,
    r.quantity, r.remarks, r.status, r.created_at
  FROM stock_requests r
  JOIN products p ON r.product_id = p.id
  LEFT JOIN categories c ON p.category_id = c.id
  LEFT JOIN sizes s ON p.size_id = s.id
  WHERE r.counter_id = $counterID
  ORDER BY r.created_at DESC";
$q = mysqli_query($conn, $sql) or die('Error fetching history: '.mysqli_error($conn));
$rows = mysqli_fetch_all($q, MYSQLI_ASSOC);

// Handle confirm receipt
if (isset($_GET['confirm']) && $_GET['confirm'] === 'true') {
  $requestID = intval($_GET['id']);
  $sql = "SELECT * FROM stock_requests WHERE id = $requestID AND counter_id = $counterID";
  $q = mysqli_query($conn, $sql) or die('Error fetching request: '.mysqli_error($conn));
  $request = mysqli_fetch_assoc($q);
  if ($request) {
    $sql = "UPDATE stock_requests SET status = 'received' WHERE id = $requestID";
    mysqli_query($conn, $sql) or die('Error updating request: '.mysqli_error($conn));
    $sql = "INSERT INTO counter_stock (counter_id, product_id, quantity) VALUES ($counterID, {$request['product_id']}, {$request['quantity']}) ON DUPLICATE KEY UPDATE quantity = quantity + {$request['quantity']}";
    mysqli_query($conn, $sql) or die('Error updating counter stock: '.mysqli_error($conn));
    header('Location: '.BASE_URL.'/panels/sales/stock_history.php');
    exit;
  }
}

ob_start();
?>
<h1 class="h2 mb-4">Stock History</h1>
<div class="mb-3">
  <a href="<?= BASE_URL ?>/panels/sales/current_stock.php" class="btn btn-secondary btn-sm">Current Stock</a>
  <a href="<?= BASE_URL ?>/panels/sales/request_stock.php" class="btn btn-primary btn-sm ms-2">New Request</a>
</div>
<div class="mb-3">
  <input type="text" id="historySearch" class="form-control w-25" placeholder="Search history...">
</div>
<table class="table table-striped" id="historyTable">
  <thead>
    <tr>
      <th>ID</th>
      <th>Product</th>
      <th>Category</th>
      <th>Size</th>
      <th>Qty</th>
      <th>Remarks</th>
      <th>Status</th>
      <th>Requested At</th>
      <th>Actions</th>
    </tr>
  </thead>
  <tbody>
    <?php foreach ($rows as $r): ?>
    <tr>
      <td><?= $r['id'] ?></td>
      <td><?= htmlspecialchars($r['product']) ?></td>
      <td><?= htmlspecialchars($r['category']) ?></td>
      <td><?= htmlspecialchars($r['size']) ?></td>
      <td><?= intval($r['quantity']) ?></td>
      <td><?= htmlspecialchars($r['remarks']) ?></td>
      <td>
        <?php
          $cls = 'secondary';
          if ($r['status']==='pending') $cls='warning';
          elseif ($r['status']==='approved') $cls='success';
          elseif ($r['status']==='dispatched') $cls='info';
          elseif ($r['status']==='rejected') $cls='danger';
          elseif ($r['status']==='received') $cls='primary';
        ?>
        <span class="badge bg-<?= $cls ?>"><?= ucfirst($r['status']) ?></span>
      </td>
      <td><?= htmlspecialchars($r['created_at']) ?></td>
      <td>
        <?php if ($r['status'] === 'dispatched'): ?>
          <a href="<?= BASE_URL ?>/panels/sales/stock_history.php?confirm=true&id=<?= $r['id'] ?>" class="btn btn-sm btn-primary">Confirm Received</a>
        <?php endif; ?>
      </td>
    </tr>
    <?php endforeach; ?>
  </tbody>
</table>
<script>
document.getElementById('historySearch').addEventListener('input', function(e) {
  const term = e.target.value.toLowerCase();
  document.querySelectorAll('#historyTable tbody tr').forEach(tr => {
    tr.style.display = tr.textContent.toLowerCase().includes(term) ? '' : 'none';
  });
});
</script>
<?php
$content = ob_get_clean();
require_once __DIR__ . '/../../includes/layout.php';
?>
