<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../includes/core.php';
if (!isLoggedIn() || getRole() !== 'sales') redirect(BASE_URL . '/login.php');
$res = mysqli_query($conn, "SELECT assigned_counter_id FROM users WHERE id={$_SESSION['user_id']}");
$counterID = intval(mysqli_fetch_assoc($res)['assigned_counter_id'] ?? 0);
// Date range
$start = $_GET['start'] ?? date('Y-m-d');
$end = $_GET['end'] ?? date('Y-m-d');
// Fetch table-wise sales (closed orders)
$sql = "SELECT o.table_id, t.table_number, COUNT(DISTINCT o.id) AS orders_count, 
           IFNULL(SUM(toi.quantity * toi.price),0) AS total_sales
        FROM table_orders o
        LEFT JOIN table_order_items toi ON o.id=toi.order_id
        LEFT JOIN tables t ON o.table_id=t.id
        WHERE o.status='closed' 
          AND o.created_at BETWEEN '$start 00:00:00' AND '$end 23:59:59'
        GROUP BY o.table_id
        ORDER BY total_sales DESC";
$q = mysqli_query($conn, $sql);
$data = mysqli_fetch_all($q, MYSQLI_ASSOC);
ob_start();
?>
<h1 class="h2 mb-4">Table-wise Sales Report</h1>
<form method="get" class="row g-3 mb-3">
  <div class="col-auto"><input type="date" name="start" value="<?= htmlspecialchars($start) ?>" class="form-control"></div>
  <div class="col-auto"><input type="date" name="end" value="<?= htmlspecialchars($end) ?>" class="form-control"></div>
  <div class="col-auto"><button type="submit" class="btn btn-primary">Filter</button></div>
</form>
<table class="table table-striped">
  <thead><tr><th>Table</th><th>Orders</th><th>Total Sales (₹)</th></tr></thead>
  <tbody>
    <?php foreach($data as $row): ?>
    <tr>
      <td><?= htmlspecialchars($row['table_number'] ?? 'N/A') ?></td>
      <td><?= intval($row['orders_count']) ?></td>
      <td>₹<?= number_format($row['total_sales'],2) ?></td>
    </tr>
    <?php endforeach; ?>
  </tbody>
</table>
<?php
$content = ob_get_clean();
require_once __DIR__ . '/../../includes/layout.php';
?>
