<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../includes/core.php';
if (!isLoggedIn() || getRole() !== 'warehouse') redirect(BASE_URL . '/login.php');

// Ensure stock_movements has necessary columns
$cols = [
    'type' => "ENUM('in','out','adjust') NOT NULL",
    'user_id' => 'INT UNSIGNED',
    'reason' => 'TEXT',
];
foreach ($cols as $col => $def) {
    $chk = mysqli_query($conn, "SHOW COLUMNS FROM `stock_movements` LIKE '$col'");
    if (mysqli_num_rows($chk) === 0) {
        mysqli_query($conn, "ALTER TABLE `stock_movements` ADD COLUMN `$col` $def") or die(mysqli_error($conn));
    }
}

// Filters
$from = $_GET['from'] ?? '';
$to = $_GET['to'] ?? '';
$where = [];
if ($from) $where[] = "sm.created_at >= '" . mysqli_real_escape_string($conn, $from . " 00:00:00") . "'";
if ($to) $where[] = "sm.created_at <= '" . mysqli_real_escape_string($conn, $to . " 23:59:59") . "'";
$w = $where ? 'WHERE ' . implode(' AND ', $where) : '';

// Fetch log
$sql = "SELECT sm.created_at, p.name AS product_name, sm.type, sm.quantity, COALESCE(u.username,'') AS user_name, sm.reason
        FROM stock_movements sm
        LEFT JOIN products p ON sm.product_id = p.id
        LEFT JOIN users u ON sm.user_id = u.id
        $w
        ORDER BY sm.created_at DESC";
$res = mysqli_query($conn, $sql) or die(mysqli_error($conn));
$data = mysqli_fetch_all($res, MYSQLI_ASSOC);

// Export CSV
if (isset($_GET['export']) && $_GET['export'] === 'csv') {
    header('Content-Type: text/csv');
    header('Content-Disposition: attachment; filename="movement_log.csv"');
    $out = fopen('php://output', 'w');
    if (!empty($data)) fputcsv($out, array_keys($data[0]));
    foreach ($data as $row) fputcsv($out, $row);
    exit;
}

ob_start();
?>
<h1 class="h2 mb-4">Movement Log</h1>
<form method="GET" class="row g-3 mb-4">
  <div class="col-md-3"><input type="date" name="from" value="<?= htmlspecialchars($from) ?>" class="form-control"></div>
  <div class="col-md-3"><input type="date" name="to" value="<?= htmlspecialchars($to) ?>" class="form-control"></div>
  <div class="col-md-6">
    <button type="submit" class="btn btn-primary">Filter</button>
    <a href="?<?= htmlspecialchars($_SERVER['QUERY_STRING']) ?>&export=csv" class="btn btn-secondary">Export CSV</a>
  </div>
</form>
<table class="table table-striped table-hover">
  <thead><tr><th>Date</th><th>Product</th><th>Action</th><th>Quantity</th><th>User</th><th>Reason</th></tr></thead>
  <tbody>
    <?php foreach ($data as $r): ?>
    <tr>
      <td><?= $r['created_at'] ?></td>
      <td><?= htmlspecialchars($r['product_name']) ?></td>
      <td><?= ucfirst($r['type']) ?></td>
      <td><?= $r['quantity'] ?></td>
      <td><?= htmlspecialchars($r['user_name']) ?></td>
      <td><?= htmlspecialchars($r['reason']) ?></td>
    </tr>
    <?php endforeach; ?>
  </tbody>
</table>
<?php
$content = ob_get_clean();
require_once __DIR__ . '/../../includes/layout.php';
?>
