<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../includes/core.php';
if (!isLoggedIn() || getRole() !== 'warehouse') redirect(BASE_URL . '/login.php');

// Filters
$suppliers = mysqli_query($conn, "SELECT id, name FROM suppliers ORDER BY name");
$from = $_GET['from'] ?? '';
$to = $_GET['to'] ?? '';
$supplier_id = intval($_GET['supplier_id'] ?? 0);
$where = [];
if ($supplier_id) $where[] = "pr.supplier_id = $supplier_id";
if ($from) $where[] = "pr.purchase_date >= '" . mysqli_real_escape_string($conn, $from . " 00:00:00") . "'";
if ($to) $where[] = "pr.purchase_date <= '" . mysqli_real_escape_string($conn, $to . " 23:59:59") . "'";
$w = $where ? 'WHERE ' . implode(' AND ', $where) : '';

// Fetch data
$sql = "SELECT pr.id AS purchase_id, pr.purchase_date, COALESCE(s.name,'') AS supplier, p.name AS product, pi.quantity, pi.unit_cost, pi.tax, pi.line_total
        FROM purchases pr
        LEFT JOIN suppliers s ON pr.supplier_id = s.id
        JOIN purchase_items pi ON pr.id = pi.purchase_id
        JOIN products p ON pi.product_id = p.id
        $w
        ORDER BY pr.purchase_date DESC";
$res = mysqli_query($conn, $sql) or die(mysqli_error($conn));
$data = mysqli_fetch_all($res, MYSQLI_ASSOC);

// Export CSV
if (isset($_GET['export']) && $_GET['export'] === 'csv') {
    header('Content-Type: text/csv');
    header('Content-Disposition: attachment; filename="purchase_report.csv"');
    $out = fopen('php://output', 'w');
    if (!empty($data)) fputcsv($out, array_keys($data[0]));
    foreach ($data as $row) fputcsv($out, $row);
    exit;
}

ob_start();
?>
<h1 class="h2 mb-4">Purchase Report</h1>
<form class="row g-3 mb-4" method="GET">
  <div class="col-md-3"><input type="date" name="from" value="<?= htmlspecialchars($from) ?>" class="form-control"></div>
  <div class="col-md-3"><input type="date" name="to" value="<?= htmlspecialchars($to) ?>" class="form-control"></div>
  <div class="col-md-3">
    <select name="supplier_id" class="form-select">
      <option value="">All Suppliers</option>
      <?php while($s = mysqli_fetch_assoc($suppliers)): ?>
      <option value="<?= $s['id'] ?>" <?= $s['id']==$supplier_id?'selected':'' ?>><?= htmlspecialchars($s['name']) ?></option>
      <?php endwhile; ?>
    </select>
  </div>
  <div class="col-3">
    <button type="submit" class="btn btn-primary">Filter</button>
    <a href="?<?= htmlspecialchars($_SERVER['QUERY_STRING']) ?>&export=csv" class="btn btn-secondary">Export CSV</a>
  </div>
</form>
<table class="table table-striped table-hover">
  <thead><tr><th>ID</th><th>Date</th><th>Supplier</th><th>Product</th><th>Qty</th><th>Unit Cost</th><th>Tax %</th><th>Line Total</th></tr></thead>
  <tbody>
    <?php foreach ($data as $r): ?>
    <tr>
      <td><?= $r['purchase_id'] ?></td>
      <td><?= $r['purchase_date'] ?></td>
      <td><?= htmlspecialchars($r['supplier']) ?></td>
      <td><?= htmlspecialchars($r['product']) ?></td>
      <td><?= $r['quantity'] ?></td>
      <td><?= number_format($r['unit_cost'],2) ?></td>
      <td><?= number_format($r['tax'],2) ?></td>
      <td><?= number_format($r['line_total'],2) ?></td>
    </tr>
    <?php endforeach; ?>
  </tbody>
</table>
<?php
$content = ob_get_clean();
require_once __DIR__ . '/../../includes/layout.php';
?>
