<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../includes/core.php';
if (!isLoggedIn() || getRole() !== 'warehouse') redirect(BASE_URL . '/login.php');

$message = '';
$errors = [];
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $product_id = intval($_POST['product_id'] ?? 0);
    $quantity = intval($_POST['quantity'] ?? 0);
    $batch_no = trim($_POST['batch_no'] ?? '');
    $po_id = intval($_POST['po_id'] ?? 0);
    $received_date = $_POST['received_date'] ?? '';

    if ($product_id <= 0) {
        $errors[] = 'Please select a product.';
    }
    if ($quantity <= 0) {
        $errors[] = 'Quantity must be at least 1.';
    }
    if ($batch_no === '') {
        $errors[] = 'Batch number is required.';
    }
    if ($received_date === '') {
        $errors[] = 'Received date is required.';
    }

    if (empty($errors)) {
        // Upsert warehouse_stock
        $res = mysqli_query($conn, "SELECT quantity FROM warehouse_stock WHERE product_id = $product_id");
        if (mysqli_num_rows($res) > 0) {
            $row = mysqli_fetch_assoc($res);
            $new_qty = $row['quantity'] + $quantity;
            mysqli_query($conn, "UPDATE warehouse_stock SET quantity = $new_qty, last_updated = NOW() WHERE product_id = $product_id");
        } else {
            mysqli_query($conn, "INSERT INTO warehouse_stock (product_id, quantity) VALUES ($product_id, $quantity)");
        }

        // Log movement
        $reason = "Batch: $batch_no" . ($po_id > 0 ? "; PO: $po_id" : '');
        $datetime = mysqli_real_escape_string($conn, ($received_date . ' ' . date('H:i:s')));
        $reason_sql = mysqli_real_escape_string($conn, $reason);
        mysqli_query(
            $conn,
            "INSERT INTO stock_movements (product_id, type, quantity, user_id, reason, created_at) VALUES ($product_id, 'in', $quantity, {$_SESSION['user_id']}, '$reason_sql', '$datetime')"
        );

        $message = 'Stock received recorded successfully.';
    }
}

// Fetch products for form
$products = [];
$sql = "SELECT p.id, p.name AS product_name, COALESCE(b.name,'') AS brand_name, COALESCE(s.name,'') AS size_name
        FROM products p
        LEFT JOIN brands b ON p.brand_id = b.id
        LEFT JOIN sizes s ON p.size_id = s.id
        ORDER BY p.name";
$res = mysqli_query($conn, $sql) or die(mysqli_error($conn));
while ($r = mysqli_fetch_assoc($res)) {
    $products[] = $r;
}

ob_start();
?>
<div class="d-flex justify-content-between align-items-center mb-4">
  <h1 class="h2">Receive Stock</h1>
</div>
<?php if ($message): ?>
<div class="alert alert-success"><?= htmlspecialchars($message) ?></div>
<?php endif; ?>
<?php if (!empty($errors)): foreach ($errors as $err): ?>
<div class="alert alert-danger"><?= htmlspecialchars($err) ?></div>
<?php endforeach; endif; ?>

<div class="card mb-4">
  <div class="card-body">
    <form method="POST">
      <div class="mb-3">
        <label class="form-label">Product</label>
        <select name="product_id" class="form-select">
<?php foreach ($products as $p): ?>
          <option value="<?= $p['id'] ?>"><?= htmlspecialchars($p['product_name'] . ' (' . $p['brand_name'] . ', ' . $p['size_name'] . ')') ?></option>
<?php endforeach; ?>
        </select>
      </div>
      <div class="mb-3">
        <label class="form-label">Quantity Received</label>
        <input type="number" name="quantity" class="form-control" min="1" required>
      </div>
      <div class="mb-3">
        <label class="form-label">Batch No</label>
        <input type="text" name="batch_no" class="form-control" required>
      </div>
      <div class="mb-3">
        <label class="form-label">Purchase Order ID (optional)</label>
        <input type="number" name="po_id" class="form-control" min="1">
      </div>
      <div class="mb-3">
        <label class="form-label">Received Date</label>
        <input type="date" name="received_date" class="form-control" value="<?= date('Y-m-d') ?>" required>
      </div>
      <button type="submit" class="btn btn-success">Submit</button>
    </form>
  </div>
</div>
<?php
$content = ob_get_clean();
require_once __DIR__ . '/../../includes/layout.php';
?>
