<?php
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../includes/core.php';
if (!isLoggedIn() || getRole() !== 'warehouse') redirect(BASE_URL . '/login.php');

// Ensure stock_requests table exists
$create = "CREATE TABLE IF NOT EXISTS `stock_requests` (
  `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `counter_id` INT UNSIGNED DEFAULT NULL,
  `product_id` INT UNSIGNED NOT NULL,
  `quantity` INT NOT NULL,
  `remarks` TEXT,
  `status` ENUM('pending','approved','dispatched','rejected') NOT NULL DEFAULT 'pending',
  `created_by` INT UNSIGNED DEFAULT NULL,
  `created_at` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_sr_counter` (`counter_id`),
  KEY `fk_sr_product` (`product_id`),
  KEY `fk_sr_user` (`created_by`),
  CONSTRAINT `fk_sr_counter` FOREIGN KEY (`counter_id`) REFERENCES `counters`(`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_sr_product` FOREIGN KEY (`product_id`) REFERENCES `products`(`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_sr_user` FOREIGN KEY (`created_by`) REFERENCES `users`(`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;";
mysqli_query($conn, $create) or die('Error ensuring stock_requests table: '.mysqli_error($conn));

$message = '';
// Handle approvals/rejections
if (isset($_GET['approve'])) {
    $id = intval($_GET['approve']);
    mysqli_query($conn, "UPDATE stock_requests SET status='approved' WHERE id = $id") or die('Error approving request: '.mysqli_error($conn));
    $message = 'Request approved.';
    redirect(BASE_URL . '/panels/warehouse/stock_requests.php');
}
if (isset($_GET['reject'])) {
    $id = intval($_GET['reject']);
    mysqli_query($conn, "UPDATE stock_requests SET status='rejected' WHERE id = $id") or die('Error rejecting request: '.mysqli_error($conn));
    $message = 'Request rejected.';
    redirect(BASE_URL . '/panels/warehouse/stock_requests.php');
}

// Fetch pending requests
$sql = "SELECT sr.id, sr.quantity, sr.remarks, sr.created_at, 
       COALESCE(c.name,'') AS counter_name, COALESCE(p.name,'') AS product_name 
    FROM stock_requests sr
    LEFT JOIN counters c ON sr.counter_id = c.id
    LEFT JOIN products p ON sr.product_id = p.id
    WHERE sr.status = 'pending'
    ORDER BY sr.created_at DESC";
$res = mysqli_query($conn, $sql) or die('Error fetching pending requests: '.mysqli_error($conn));
$rows = mysqli_fetch_all($res, MYSQLI_ASSOC);

ob_start();
?>
<div class="d-flex justify-content-between align-items-center mb-4">
  <h1 class="h2">Pending Stock Requests</h1>
</div>
<?php if ($message): ?>
<div class="alert alert-success"><?= htmlspecialchars($message) ?></div>
<?php endif; ?>
<table class="table table-striped table-hover">
  <thead>
    <tr>
      <th>ID</th>
      <th>Date</th>
      <th>Counter</th>
      <th>Product</th>
      <th>Quantity</th>
      <th>Remarks</th>
      <th>Actions</th>
    </tr>
  </thead>
  <tbody>
    <?php foreach ($rows as $r): ?>
    <tr>
      <td><?= $r['id'] ?></td>
      <td><?= $r['created_at'] ?></td>
      <td><?= htmlspecialchars($r['counter_name']) ?></td>
      <td><?= htmlspecialchars($r['product_name']) ?></td>
      <td><?= $r['quantity'] ?></td>
      <td><?= htmlspecialchars($r['remarks']) ?></td>
      <td>
        <a href="?approve=<?= $r['id'] ?>" class="btn btn-sm btn-success" onclick="return confirm('Approve this request?')">Approve</a>
        <a href="?reject=<?= $r['id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('Reject this request?')">Reject</a>
      </td>
    </tr>
    <?php endforeach; ?>
  </tbody>
</table>
<?php
$content = ob_get_clean();
require_once __DIR__ . '/../../includes/layout.php';
?>
