<?php
/**
 * run_schema.php
 *
 * Drops and recreates the bar_management database using schema.sql.
 * Usage: php run_schema.php
 */
require __DIR__ . '/includes/config.php';

// Connect without selecting a DB
$conn = mysqli_connect(DB_HOST, DB_USER, DB_PASS);
if (!$conn) {
    die("Connection failed: " . mysqli_connect_error() . PHP_EOL);
}

// Read raw SQL
$sql = file_get_contents(__DIR__ . '/schema.sql');
if ($sql === false) {
    die("Could not read schema.sql" . PHP_EOL);
}

// Build full SQL commands
$cmds = [];
$cmds[] = "DROP DATABASE IF EXISTS `" . DB_NAME . "`;";
$cmds[] = "CREATE DATABASE `" . DB_NAME . "` DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci;";
$cmds[] = "USE `" . DB_NAME . "`;";
$cmds[] = "SET FOREIGN_KEY_CHECKS = 0;";
$cmds[] = $sql;
$cmds[] = "SET FOREIGN_KEY_CHECKS = 1;";

$allSql = implode("\n", $cmds);

// Execute multi-query
if (!mysqli_multi_query($conn, $allSql)) {
    die("Error importing schema: " . mysqli_error($conn) . PHP_EOL);
}

do {
    /* flush results */
} while (mysqli_more_results($conn) && mysqli_next_result($conn));

echo "Database '" . DB_NAME . "' has been recreated and schema imported successfully." . PHP_EOL;
